/*
 * Decompiled with CFR 0.152.
 */
package org.repodriller.plugin.jdt;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.repodriller.plugin.jdt.JDTVisitor;

public class JDTFileRequestor
extends FileASTRequestor {
    private static Logger log = Logger.getLogger(JDTFileRequestor.class);
    private Callable<List<JDTVisitor>> metrics;

    public JDTFileRequestor(Callable<List<JDTVisitor>> metrics) {
        this.metrics = metrics;
    }

    public void acceptAST(String sourceFilePath, CompilationUnit cu) {
        log.info((Object)("Visiting " + sourceFilePath));
        try {
            for (JDTVisitor visitor : this.metrics.call()) {
                log.info((Object)("Applying " + visitor.getClass().getName()));
                visitor.execute(cu, sourceFilePath);
            }
        }
        catch (Exception e) {
            log.error((Object)("error in " + sourceFilePath), (Throwable)e);
        }
    }
}

