/*
 * Decompiled with CFR 0.152.
 */
package org.repodriller.plugin.jdt;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.repodriller.plugin.jdt.FileUtils;
import org.repodriller.plugin.jdt.JDTFileRequestor;
import org.repodriller.plugin.jdt.JDTVisitor;

public class JDTRunner {
    private static Logger log = Logger.getLogger(JDTRunner.class);
    private boolean resolveBindings;
    private boolean bindingsRecovery;
    private static final int MAX_AT_ONCE;

    public JDTRunner(boolean resolveBindings, boolean bindingsRecovery) {
        this.resolveBindings = resolveBindings;
        this.bindingsRecovery = bindingsRecovery;
    }

    public void run(String[] srcDirs, String[] javaFiles, Callable<List<JDTVisitor>> metrics) {
        JDTFileRequestor storage = new JDTFileRequestor(metrics);
        List partitions = Lists.partition(Arrays.asList(javaFiles), (int)MAX_AT_ONCE);
        log.info((Object)("Max partition size: " + MAX_AT_ONCE + ", total partitions=" + partitions.size()));
        int count = 0;
        for (List partition : partitions) {
            log.info((Object)("Next partition " + ++count));
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setResolveBindings(this.resolveBindings);
            parser.setBindingsRecovery(this.bindingsRecovery);
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions((String)"1.8", (Map)options);
            parser.setCompilerOptions((Map)options);
            parser.setEnvironment(null, srcDirs, null, true);
            parser.createASTs(partition.toArray(new String[partition.size()]), null, new String[0], (FileASTRequestor)storage, null);
        }
        log.info((Object)"Finished parsing");
    }

    public void run(String path, Callable<List<JDTVisitor>> metrics) {
        String[] srcDirs = FileUtils.getAllDirs(path);
        String[] javaFiles = FileUtils.getAllJavaFiles(path);
        log.info((Object)("Found " + javaFiles.length + " java files in " + path));
        this.run(srcDirs, javaFiles, metrics);
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        MAX_AT_ONCE = maxMemory >= 2000L ? 400 : (maxMemory >= 1500L ? 300 : (maxMemory >= 1000L ? 200 : (maxMemory >= 500L ? 100 : 25)));
    }
}

