/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class RevolvingCounter {
    private final long initialValue;
    private final long limit;
    private AtomicLong count;
    private final Lock lock;

    public RevolvingCounter(long limit) {
        this(0L, limit);
    }

    public RevolvingCounter(long initialValue, long limit) {
        this.initialValue = initialValue;
        this.limit = limit;
        this.count = new AtomicLong();
        this.count.set(initialValue);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndIncrement() {
        long result = this.count.getAndIncrement();
        if (result >= this.limit) {
            while (!this.lock.tryLock()) {
            }
            try {
                if (this.count.get() >= this.limit) {
                    result = this.initialValue;
                    this.count.set(this.initialValue + 1L);
                } else {
                    result = this.getAndIncrement();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return result;
    }

    public long getCount() {
        return this.count.get();
    }
}

