/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.fsm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mobicents.commons.event.Event;
import org.mobicents.commons.fsm.Action;
import org.mobicents.commons.fsm.Condition;
import org.mobicents.commons.fsm.FiniteStateMachineException;
import org.mobicents.commons.fsm.State;
import org.mobicents.commons.fsm.Transition;
import org.mobicents.commons.fsm.TransitionFailedException;
import org.mobicents.commons.fsm.TransitionNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FiniteStateMachine {
    private final Lock lock = new ReentrantLock();
    private State state;
    private Map<State, Map<State, Transition>> transitions;

    protected FiniteStateMachine() {
    }

    private boolean canTransitionTo(State state) {
        return this.transitions.get(this.state).containsKey(state);
    }

    private void checkIsInitialized() throws FiniteStateMachineException {
        if (this.state == null || this.transitions == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("The finite state machine has not been initialized. ");
            buffer.append("Please initialize the state machine before using it.");
            throw new FiniteStateMachineException(buffer.toString());
        }
    }

    private void checkNotNull(State state) throws NullPointerException {
        if (state == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("The state parameter can not be null. ");
            buffer.append("Please provide a usable state and try again.");
            throw new NullPointerException(buffer.toString());
        }
    }

    private void checkNotNull(State state, Set<Transition> transitions) throws NullPointerException {
        this.checkNotNull(state);
        if (transitions == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("The transitions parameter can not be null. ");
            buffer.append("Please provide a set of transitions and try again.");
            throw new NullPointerException(buffer.toString());
        }
    }

    private String conditionFailed(Event<?> event, Transition transition) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("The condition guarding a transition from a(n) ");
        buffer.append(transition.getStateOnEnter().getId());
        buffer.append(" state to a(n) ").append(transition.getStateOnExit().getId());
        buffer.append(" state has failed. The event type that caused the failure is of type ");
        buffer.append(event.getType().getClass().getName());
        return buffer.toString();
    }

    private String finiteStateMachineFailed() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("This finite state machine failed. It may be in an illegal or unusable state.");
        buffer.append("Please re-initialize before continuing use of this finite state machine.");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State getState() {
        this.lock();
        try {
            State state = this.state;
            return state;
        }
        finally {
            this.unlock();
        }
    }

    private Transition getTransitionTo(State state) {
        return this.transitions.get(this.state).get(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(State state, Set<Transition> transitions) {
        this.checkNotNull(state, transitions);
        this.lock();
        try {
            this.state = state;
            this.transitions = this.toImmutableMap(transitions);
        }
        finally {
            this.unlock();
        }
    }

    protected void lock() {
        this.lock.lock();
    }

    private String noTransitionFound(State from, State to) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("No transition could be found from a(n) ");
        buffer.append(from.getId()).append(" state to a(n) ");
        buffer.append(to.getId()).append(" state.");
        return buffer.toString();
    }

    protected <T> void transition(Event<T> event, State state) throws FiniteStateMachineException, NullPointerException, TransitionFailedException, TransitionNotFoundException {
        block10: {
            this.checkNotNull(state);
            this.checkIsInitialized();
            this.lock();
            try {
                if (!this.canTransitionTo(state)) {
                    String message = this.noTransitionFound(this.state, state);
                    throw new TransitionNotFoundException(message, event, state);
                }
                Transition transition = this.getTransitionTo(state);
                Condition condition = transition.getCondition();
                boolean accept = true;
                if (condition != null) {
                    accept = condition.accept(event, transition);
                }
                if (accept) {
                    Action actionOnExit = this.state.getActionOnExit();
                    if (actionOnExit != null) {
                        actionOnExit.execute(event, this.state);
                    }
                    this.state = state;
                    Action actionOnEnter = this.state.getActionOnEnter();
                    if (actionOnEnter != null) {
                        actionOnEnter.execute(event, this.state);
                    }
                    break block10;
                }
                String message = this.conditionFailed(event, transition);
                throw new TransitionFailedException(message, event, transition);
            }
            catch (RuntimeException exception) {
                String message = this.finiteStateMachineFailed();
                throw new FiniteStateMachineException(message, exception);
            }
            finally {
                this.unlock();
            }
        }
    }

    private Map<State, Map<State, Transition>> toImmutableMap(Set<Transition> transitions) {
        HashMap map = new HashMap();
        for (Transition transition : transitions) {
            State stateOnEnter = transition.getStateOnEnter();
            if (!map.containsKey(stateOnEnter)) {
                map.put(stateOnEnter, new HashMap());
            }
            State stateOnExit = transition.getStateOnExit();
            ((Map)map.get(stateOnEnter)).put(stateOnExit, transition);
        }
        return Collections.unmodifiableMap(map);
    }

    protected boolean tryLock() {
        return this.lock.tryLock();
    }

    protected void unlock() {
        this.lock.unlock();
    }
}

