/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.fsm;

import org.mobicents.commons.fsm.Action;

public class State {
    private final Action actionOnEnter;
    private final Action actionOnExit;
    private final String id;

    public State(String id, Action actionOnEnter, Action actionOnExit) {
        this.checkNotNull(id);
        this.actionOnEnter = actionOnEnter;
        this.actionOnExit = actionOnExit;
        this.id = id;
    }

    private void checkNotNull(String id) throws NullPointerException {
        if (id == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("A state can not be built with a null value for the id parameter.");
            throw new NullPointerException(buffer.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        State state = (State)object;
        return this.id.equals(state.getId());
    }

    public Action getActionOnEnter() {
        return this.actionOnEnter;
    }

    public Action getActionOnExit() {
        return this.actionOnExit;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 5;
        int result = 1;
        result = 5 * result + this.id.hashCode();
        return result;
    }
}

