/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.event;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;
import org.mobicents.commons.event.Event;
import org.mobicents.commons.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class);
    private final List<Dispatcher> dispatchers;
    private final AbstractSet<EventHandler> handlers;
    private final BlockingQueue<Event<?>> queue;

    private EventBus(List<Dispatcher> dispatchers, Executor executor, AbstractSet<EventHandler> handlers, BlockingQueue<Event<?>> queue) {
        this.dispatchers = dispatchers;
        this.handlers = handlers;
        this.queue = queue;
        for (Dispatcher dispatcher : dispatchers) {
            executor.execute(dispatcher);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(EventHandler handler) {
        return this.handlers.contains(handler);
    }

    public void emit(Event<?> event) throws InterruptedException {
        this.queue.put(event);
    }

    public void register(EventHandler handler) {
        this.handlers.add(handler);
    }

    public void terminate() {
        for (Dispatcher dispatcher : this.dispatchers) {
            dispatcher.stop();
        }
    }

    public void unregister(EventHandler handler) {
        this.handlers.remove(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Dispatcher
    implements Runnable {
        private final AbstractSet<EventHandler> handlers;
        private final BlockingQueue<Event<?>> queue;
        private volatile boolean dispatching = true;

        private Dispatcher(AbstractSet<EventHandler> handlers, BlockingQueue<Event<?>> queue) {
            this.handlers = handlers;
            this.queue = queue;
        }

        @Override
        public void run() {
            while (this.dispatching) {
                Event<?> event = null;
                try {
                    event = this.queue.take();
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                if (event == null) continue;
                for (EventHandler handler : this.handlers) {
                    if (logger.isTraceEnabled()) {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append("Processing a(n) event of type ");
                        buffer.append(event.getType().toString()).append(".\n");
                        buffer.append(event.toString());
                        logger.trace((Object)buffer.toString());
                    }
                    try {
                        if (!handler.accept(event)) continue;
                        handler.handle(event);
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception);
                    }
                }
            }
        }

        public synchronized void stop() {
            if (this.dispatching) {
                this.dispatching = false;
            }
        }
    }

    public static final class Builder {
        private Executor executor = null;
        private int numberOfThreads = 1;
        private int queueSize = 10;

        private Builder() {
        }

        public EventBus build() {
            this.checkNotNull(this.executor);
            CopyOnWriteArraySet handlers = new CopyOnWriteArraySet();
            ArrayBlockingQueue queue = new ArrayBlockingQueue(this.queueSize);
            ArrayList<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
            for (int counter = 0; counter < this.numberOfThreads; ++counter) {
                dispatchers.add(new Dispatcher(handlers, queue));
            }
            return new EventBus(Collections.unmodifiableList(dispatchers), this.executor, handlers, queue);
        }

        private void checkNotNull(Executor executor) throws NullPointerException {
            if (executor == null) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("An event bus can not be built with a null value for the executor.\n");
                buffer.append("Please set an executor before calling the build() method on ");
                buffer.append(this.getClass().getName());
                throw new NullPointerException(buffer.toString());
            }
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setNumberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public Builder setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }
    }
}

