/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.commons.statistics.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.restcomm.commons.statistics.sender.RestcommStatsSender;

public class RestcommStatsReporter
extends ScheduledReporter {
    private final Clock clock;
    private Map<String, Object> values;
    private String remoteServer;

    public RestcommStatsReporter(MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock) {
        super(registry, "restcomm-stats-reporter", filter, rateUnit, durationUnit);
        this.clock = clock;
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.values = new HashMap<String, Object>();
            this.values.put("timestamp", timestamp);
            this.values.put("key", entry.getKey());
            this.values.put("value", entry.getValue().getValue());
            RestcommStatsSender.sendStats(this.values, "gauge", this.remoteServer);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.values = new HashMap<String, Object>();
            this.values.put("timestamp", timestamp);
            this.values.put("key", entry.getKey());
            this.values.put("count", ((Counter)entry.getValue()).getCount());
            RestcommStatsSender.sendStats(this.values, "counter", this.remoteServer);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.values = new HashMap<String, Object>();
            this.values.put("timestamp", timestamp);
            this.values.put("key", entry.getKey());
            this.values.put("count", ((Histogram)entry.getValue()).getCount());
            this.values.put("size", ((Histogram)entry.getValue()).getSnapshot().size());
            this.values.put("max", ((Histogram)entry.getValue()).getSnapshot().getMax());
            this.values.put("mean", ((Histogram)entry.getValue()).getSnapshot().getMean());
            this.values.put("media", ((Histogram)entry.getValue()).getSnapshot().getMedian());
            this.values.put("min", ((Histogram)entry.getValue()).getSnapshot().getMin());
            this.values.put("stdDev", ((Histogram)entry.getValue()).getSnapshot().getStdDev());
            this.values.put("75th", ((Histogram)entry.getValue()).getSnapshot().get75thPercentile());
            this.values.put("95th", ((Histogram)entry.getValue()).getSnapshot().get95thPercentile());
            this.values.put("98th", ((Histogram)entry.getValue()).getSnapshot().get98thPercentile());
            this.values.put("99th", ((Histogram)entry.getValue()).getSnapshot().get99thPercentile());
            this.values.put("999th", ((Histogram)entry.getValue()).getSnapshot().get999thPercentile());
            RestcommStatsSender.sendStats(this.values, "histogram", this.remoteServer);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.values = new HashMap<String, Object>();
            this.values.put("timestamp", timestamp);
            this.values.put("key", entry.getKey());
            this.values.put("count", ((Meter)entry.getValue()).getCount());
            this.values.put("fifteenMinuteRate", ((Meter)entry.getValue()).getFifteenMinuteRate());
            this.values.put("fiveMinuteRate", ((Meter)entry.getValue()).getFiveMinuteRate());
            this.values.put("meanRate", ((Meter)entry.getValue()).getMeanRate());
            this.values.put("oneMinuteRate", ((Meter)entry.getValue()).getOneMinuteRate());
            RestcommStatsSender.sendStats(this.values, "meter", this.remoteServer);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.values = new HashMap<String, Object>();
            this.values.put("timestamp", timestamp);
            this.values.put("key", entry.getKey());
            this.values.put("count", ((Timer)entry.getValue()).getCount());
            this.values.put("fifteenMinuteRate", ((Timer)entry.getValue()).getFifteenMinuteRate());
            this.values.put("fiveMinuteRate", ((Timer)entry.getValue()).getFiveMinuteRate());
            this.values.put("meanRate", ((Timer)entry.getValue()).getMeanRate());
            this.values.put("oneMinuteRate", ((Timer)entry.getValue()).getOneMinuteRate());
            this.values.put("size", ((Timer)entry.getValue()).getSnapshot().size());
            this.values.put("max", ((Timer)entry.getValue()).getSnapshot().getMax());
            this.values.put("mean", ((Timer)entry.getValue()).getSnapshot().getMean());
            this.values.put("media", ((Timer)entry.getValue()).getSnapshot().getMedian());
            this.values.put("min", ((Timer)entry.getValue()).getSnapshot().getMin());
            this.values.put("stdDev", ((Timer)entry.getValue()).getSnapshot().getStdDev());
            this.values.put("75th", ((Timer)entry.getValue()).getSnapshot().get75thPercentile());
            this.values.put("95th", ((Timer)entry.getValue()).getSnapshot().get95thPercentile());
            this.values.put("98th", ((Timer)entry.getValue()).getSnapshot().get98thPercentile());
            this.values.put("99th", ((Timer)entry.getValue()).getSnapshot().get99thPercentile());
            this.values.put("999th", ((Timer)entry.getValue()).getSnapshot().get999thPercentile());
            RestcommStatsSender.sendStats(this.values, "timer", this.remoteServer);
        }
    }

    public String getRemoteServer() {
        return this.remoteServer;
    }

    public void setRemoteServer(String remoteServer) {
        this.remoteServer = remoteServer;
    }

    public static class Builder {
        private final MetricRegistry registry;
        private final Clock clock;
        private final TimeUnit rateUnit;
        private final TimeUnit durationUnit;
        private final MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public RestcommStatsReporter build() {
            return new RestcommStatsReporter(this.registry, this.filter, this.rateUnit, this.durationUnit, this.clock);
        }
    }
}

