/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.commons.statistics.sender;

import com.google.gson.Gson;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class RestcommStatsSender {
    private static String remoteServer;
    private static ResteasyClient client;
    private static Gson gson;
    private static final Logger LOGGER;
    private static Properties properties;

    public static void sendStats(Map<String, Object> values, String statsType, String serverAddress) {
        if (serverAddress != null) {
            remoteServer = serverAddress;
        }
        RestcommStatsSender.sendStats(values, statsType);
    }

    public static void sendStats(Map<String, Object> values, String statsType) {
        Response res = client.target(UriBuilder.fromPath((String)remoteServer.concat(statsType))).request(new String[]{"application/json"}).post(Entity.json((Object)gson.toJson(values)));
        if (res.getStatus() != 200) {
            LOGGER.log(Level.SEVERE, "{0} - {1}", new Object[]{res.getStatus(), res.getStatusInfo().getReasonPhrase()});
        }
        res.close();
    }

    static {
        gson = new Gson();
        LOGGER = Logger.getLogger("restcomm-stats");
        remoteServer = ResourceBundle.getBundle("config").getString("remote-server");
        client = new ResteasyClientBuilder().build();
    }
}

