/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.commons.statistics.sender;

import com.google.gson.Gson;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class RestcommStatsSender {
    private static String remoteServer;
    private static ResteasyClient client;
    private static Gson gson;
    private static final Logger LOGGER;

    public static boolean sendStats(Map<String, Object> values, String statsType, String serverAddress) {
        if (serverAddress != null) {
            remoteServer = serverAddress;
        }
        return RestcommStatsSender.sendStats(values, statsType);
    }

    public static boolean sendStats(Map<String, Object> values, String statsType) {
        String jsonString = gson.toJson(values);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "send Stats {0} to {1}", new Object[]{jsonString, remoteServer});
        }
        try {
            Response res = client.target(UriBuilder.fromPath((String)remoteServer.concat(statsType))).request(new String[]{"application/json"}).post(Entity.json((Object)jsonString));
            if (res.getStatus() > 200) {
                LOGGER.log(Level.SEVERE, "{0} - {1}", new Object[]{res.getStatus(), res.getStatusInfo().getReasonPhrase()});
                res.close();
                return false;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0} - {1}", new Object[]{res.getStatus(), res.getStatusInfo().getReasonPhrase()});
            }
            res.close();
            return true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                if (e.getCause() != null) {
                    LOGGER.log(Level.INFO, "couldn't send stats data to " + remoteServer + " because of " + e.getMessage() + ", root cause: " + e.getCause().getMessage());
                } else {
                    LOGGER.log(Level.INFO, "couldn't send stats data to " + remoteServer + " because of " + e.getMessage());
                }
            }
            return false;
        }
    }

    static {
        gson = new Gson();
        LOGGER = Logger.getLogger("restcomm-stats");
        remoteServer = ResourceBundle.getBundle("config").getString("remote-server");
        client = new ResteasyClientBuilder().build();
    }
}

