/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.commons.statistics.sender;

import com.google.gson.Gson;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class RestcommStatsSender {
    private static String remoteServer;
    private static Gson gson;
    private static final Logger LOGGER;

    public static boolean sendStats(Map<String, Object> values, String statsType, String serverAddress) {
        if (serverAddress != null) {
            remoteServer = serverAddress;
        }
        return RestcommStatsSender.sendStats(values, statsType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendStats(Map<String, Object> values, String statsType) {
        String jsonString = gson.toJson(values);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "send Stats {0} to {1}", new Object[]{jsonString, remoteServer});
        }
        CloseableHttpClient client = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).setCookieSpec("standard").build();
            client = HttpClients.custom().setSslcontext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build()).setDefaultRequestConfig(requestConfig).build();
            HttpPost post = new HttpPost(remoteServer.concat(statsType));
            StringEntity se = new StringEntity(jsonString);
            se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() > 200) {
                LOGGER.log(Level.SEVERE, "{0} - {1}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                boolean bl = false;
                return bl;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0} - {1}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                if (e.getCause() != null) {
                    LOGGER.log(Level.INFO, "couldn't send stats data to " + remoteServer + " because of " + e.getMessage() + ", root cause: " + e.getCause().getMessage());
                } else {
                    LOGGER.log(Level.INFO, "couldn't send stats data to " + remoteServer + " because of " + e.getMessage());
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block21: {
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block21;
                    LOGGER.log(Level.INFO, "couldn't close the httpclient for " + remoteServer + " because of " + e.getMessage());
                }
            }
        }
    }

    static {
        gson = new Gson();
        LOGGER = Logger.getLogger("restcomm-stats");
        remoteServer = ResourceBundle.getBundle("config").getString("remote-server");
    }
}

