/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.event;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.event.ListenerMethod;

public class PolymEventDispatcher
implements SquirrelComponent {
    private LinkedHashSet<ListenerMethod> listeners = null;

    public void register(Class<?> eventType, Object listener, Method method) {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet();
        }
        this.listeners.add(new ListenerMethod(eventType, listener, method));
    }

    public void unregister(Predicate<ListenerMethod> predicate) {
        if (this.listeners != null) {
            Iterators.removeIf(this.listeners.iterator(), predicate);
        }
    }

    public void unregister(final Class<?> eventType, final Object target) {
        if (this.listeners != null) {
            Iterators.removeIf(this.listeners.iterator(), (Predicate)new Predicate<ListenerMethod>(){

                public boolean apply(ListenerMethod m) {
                    return m.matches(eventType, target);
                }
            });
        }
    }

    public void unregister(final Class<?> eventType, final Object target, final Method method) {
        ListenerMethod toBeRemove;
        if (this.listeners != null && (toBeRemove = (ListenerMethod)Iterators.find(this.listeners.iterator(), (Predicate)new Predicate<ListenerMethod>(){

            public boolean apply(ListenerMethod m) {
                return m.matches(eventType, target, method);
            }
        })) != null) {
            this.listeners.remove(toBeRemove);
        }
    }

    public void unregisterAll() {
        this.listeners = null;
    }

    public void fireEvent(Object event) {
        if (this.listeners == null) {
            return;
        }
        ListenerMethod[] listenerArray = this.listeners.toArray(new ListenerMethod[this.listeners.size()]);
        for (int i = 0; i < listenerArray.length; ++i) {
            if (!listenerArray[i].getEventType().isAssignableFrom(event.getClass())) continue;
            listenerArray[i].invokeMethod(event);
        }
    }

    public int getListenerSize() {
        return this.listeners != null ? this.listeners.size() : 0;
    }
}

