/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.builder.And;
import org.squirrelframework.foundation.fsm.builder.Between;
import org.squirrelframework.foundation.fsm.builder.From;
import org.squirrelframework.foundation.fsm.builder.MultiFrom;
import org.squirrelframework.foundation.fsm.builder.MultiTo;
import org.squirrelframework.foundation.fsm.builder.MultiTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.To;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;

class MultiTransitionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements MultiTransitionBuilder<T, S, E, C>,
MultiFrom<T, S, E, C>,
From<T, S, E, C>,
MultiTo<T, S, E, C>,
To<T, S, E, C>,
On<T, S, E, C>,
Between<T, S, E, C>,
And<T, S, E, C>,
SquirrelComponent {
    private final List<MutableTransition<T, S, E, C>> transitions = Lists.newArrayList();
    private final List<MutableState<T, S, E, C>> sourceStates = Lists.newArrayList();
    private final List<MutableState<T, S, E, C>> targetStates = Lists.newArrayList();
    private final Map<S, MutableState<T, S, E, C>> states;
    private final int priority;
    private final ExecutionContext executionContext;
    private final TransitionType transitionType;

    MultiTransitionBuilderImpl(Map<S, MutableState<T, S, E, C>> states, TransitionType transitionType, int priority, ExecutionContext executionContext) {
        this.states = states;
        this.transitionType = transitionType;
        this.priority = priority;
        this.executionContext = executionContext;
    }

    @Override
    public MultiTo<T, S, E, C> toAmong(S ... stateIds) {
        for (S stateId : stateIds) {
            this.targetStates.add(FSM.getState(this.states, stateId));
        }
        return this;
    }

    @Override
    public To<T, S, E, C> to(S stateId) {
        this.targetStates.add(FSM.getState(this.states, stateId));
        return this;
    }

    @Override
    public To<T, S, E, C> toFinal(S stateId) {
        MutableState<T, S, E, C> targetState = FSM.getState(this.states, stateId);
        if (!targetState.isFinalState()) {
            targetState.setFinal(true);
        }
        this.targetStates.add(targetState);
        return this;
    }

    @Override
    public MultiFrom<T, S, E, C> from(S stateId) {
        this.sourceStates.add(FSM.getState(this.states, stateId));
        return this;
    }

    @Override
    public From<T, S, E, C> fromAmong(S ... stateIds) {
        for (S stateId : stateIds) {
            this.sourceStates.add(FSM.getState(this.states, stateId));
        }
        return this;
    }

    @Override
    public Between<T, S, E, C> between(S fromStateId) {
        this.sourceStates.add(FSM.getState(this.states, fromStateId));
        return this;
    }

    @Override
    public And<T, S, E, C> and(S stateId) {
        this.targetStates.add(FSM.getState(this.states, stateId));
        return this;
    }

    @Override
    public On<T, S, E, C> onMutual(E fromEvent, E toEvent) {
        MutableTransition<T, S, E, C> forwardTransition = this.sourceStates.get(0).addTransitionOn(fromEvent);
        forwardTransition.setTargetState(this.targetStates.get(0));
        forwardTransition.setType(this.transitionType);
        forwardTransition.setPriority(this.priority);
        this.transitions.add(forwardTransition);
        MutableTransition<T, S, E, C> backwardTransition = this.targetStates.get(0).addTransitionOn(toEvent);
        backwardTransition.setTargetState(this.sourceStates.get(0));
        backwardTransition.setType(this.transitionType);
        backwardTransition.setPriority(this.priority);
        this.transitions.add(backwardTransition);
        return this;
    }

    @Override
    public On<T, S, E, C> on(E event) {
        for (MutableState<T, S, E, C> sourceState : this.sourceStates) {
            for (MutableState<T, S, E, C> targetState : this.targetStates) {
                MutableTransition<T, S, E, C> transition = sourceState.addTransitionOn(event);
                transition.setTargetState(targetState);
                transition.setType(this.transitionType);
                transition.setPriority(this.priority);
                this.transitions.add(transition);
            }
        }
        return this;
    }

    @Override
    public On<T, S, E, C> onEach(E ... events) {
        Preconditions.checkNotNull(events);
        int eventLength = events.length;
        int srcStateLength = this.sourceStates.size();
        for (int i = 0; i < srcStateLength; ++i) {
            int tarStateLength = this.targetStates.size();
            for (int j = 0; j < tarStateLength; ++j) {
                int statePos = j < i ? i : j;
                int eventPos = statePos < eventLength ? statePos : eventLength - 1;
                MutableTransition<T, S, E, C> transition = this.sourceStates.get(i).addTransitionOn(events[eventPos]);
                transition.setTargetState(this.targetStates.get(j));
                transition.setType(this.transitionType);
                transition.setPriority(this.priority);
                this.transitions.add(transition);
            }
        }
        return this;
    }

    @Override
    public When<T, S, E, C> when(Condition<C> condition) {
        for (MutableTransition<T, S, E, C> transition : this.transitions) {
            transition.setCondition(condition);
        }
        return this;
    }

    @Override
    public When<T, S, E, C> whenMvel(String expression) {
        for (MutableTransition transition : this.transitions) {
            Condition cond = FSM.newMvelCondition(expression, this.executionContext.getScriptManager());
            transition.setCondition(cond);
        }
        return this;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        for (MutableTransition<T, S, E, C> transition : this.transitions) {
            transition.addAction(action);
        }
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> actions) {
        int actionSize = actions.size();
        int transitionLength = this.transitions.size();
        for (int i = 0; i < transitionLength; ++i) {
            int actionPos = i < actionSize ? i : actionSize - 1;
            this.transitions.get(i).addAction(actions.get(actionPos));
        }
    }

    @Override
    public void evalMvel(String expression) {
        for (MutableTransition transition : this.transitions) {
            Action action = FSM.newMvelAction(expression, this.executionContext);
            transition.addAction(action);
        }
    }

    @Override
    public void callMethod(String methodName) {
        String[] methods = StringUtils.split((String)methodName, (char)'|');
        int methodsLength = methods.length;
        int transitionLength = this.transitions.size();
        for (int i = 0; i < transitionLength; ++i) {
            int methodPos = i < methodsLength ? i : methodsLength - 1;
            String theMethodName = methods[methodPos].trim();
            if ("_".equals(theMethodName)) continue;
            MethodCallActionProxyImpl action = FSM.newMethodCallActionProxy(theMethodName, this.executionContext);
            this.transitions.get(i).addAction(action);
        }
    }
}

