/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Actions;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateCompositeType;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineData;
import org.squirrelframework.foundation.fsm.TransitionResult;
import org.squirrelframework.foundation.fsm.Visitor;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.impl.FSM;

class StateImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements MutableState<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(StateImpl.class);
    protected final S stateId;
    protected final Actions<T, S, E, C> entryActions = FSM.newActions();
    protected final Actions<T, S, E, C> exitActions = FSM.newActions();
    private LinkedListMultimap<E, ImmutableTransition<T, S, E, C>> transitions;
    private Set<E> acceptableEvents;
    private MutableState<T, S, E, C> parentState;
    private List<MutableState<T, S, E, C>> childStates;
    private MutableState<T, S, E, C> childInitialState;
    private HistoryType historyType = HistoryType.NONE;
    private int level = 0;
    private boolean isFinalState = false;
    private StateCompositeType compositeType = StateCompositeType.SEQUENTIAL;

    StateImpl(S stateId) {
        this.stateId = stateId;
    }

    @Override
    public S getStateId() {
        return this.stateId;
    }

    @Override
    public List<Action<T, S, E, C>> getEntryActions() {
        return this.entryActions.getAll();
    }

    @Override
    public List<Action<T, S, E, C>> getExitActions() {
        return this.exitActions.getAll();
    }

    @Override
    public List<ImmutableTransition<T, S, E, C>> getAllTransitions() {
        if (this.transitions == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)this.getTransitions().values());
    }

    @Override
    public List<ImmutableTransition<T, S, E, C>> getTransitions(E event) {
        if (this.transitions == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)this.getTransitions().get(event));
    }

    @Override
    public Set<E> getAcceptableEvents() {
        if (this.acceptableEvents == null) {
            HashSet events = Sets.newHashSet();
            events.addAll(this.getTransitions().keySet());
            this.acceptableEvents = Collections.unmodifiableSet(events);
        }
        return this.acceptableEvents;
    }

    @Override
    public void prioritizeTransitions() {
        for (Object key : this.getTransitions().keySet()) {
            List trans = this.transitions.get(key);
            Collections.sort(trans, new Comparator<ImmutableTransition<T, S, E, C>>(){

                @Override
                public int compare(ImmutableTransition<T, S, E, C> o1, ImmutableTransition<T, S, E, C> o2) {
                    return o2.getPriority() - o1.getPriority();
                }
            });
        }
    }

    @Override
    public void entry(StateContext<T, S, E, C> stateContext) {
        stateContext.getExecutor().begin("STATE_ENTRY__" + this.getStateId());
        for (Action<T, S, E, C> action : this.getEntryActions()) {
            stateContext.getExecutor().defer(action, null, this.getStateId(), stateContext.getEvent(), stateContext.getContext(), stateContext.getStateMachine().getThis());
        }
        if (this.isParallelState()) {
            for (ImmutableState immutableState : this.getChildStates()) {
                immutableState.entry(stateContext);
                ImmutableState<T, S, E, C> subState = immutableState.enterByHistory(stateContext);
                stateContext.getStateMachineData().write().subStateFor(this.getStateId(), subState.getStateId());
            }
        }
        logger.debug("State \"" + this.getStateId() + "\" entry.");
    }

    @Override
    public void exit(StateContext<T, S, E, C> stateContext) {
        if (this.isParallelState()) {
            List<ImmutableState<T, S, E, C>> subStates = this.getSubStatesOn(this, stateContext.getStateMachineData().read());
            for (ImmutableState<T, S, E, C> subState : subStates) {
                if (!subState.isFinalState()) {
                    subState.exit(stateContext);
                }
                if (subState.getParentState() == this) continue;
                subState.getParentState().exit(stateContext);
            }
            stateContext.getStateMachineData().write().removeSubStatesOn(this.getStateId());
        }
        if (this.isFinalState()) {
            return;
        }
        stateContext.getExecutor().begin("STATE_EXIT__" + this.getStateId());
        for (Action<T, S, E, C> exitAction : this.getExitActions()) {
            stateContext.getExecutor().defer(exitAction, this.getStateId(), null, stateContext.getEvent(), stateContext.getContext(), stateContext.getStateMachine().getThis());
        }
        if (this.getParentState() != null) {
            boolean shouldUpdateHistoricalState;
            ImmutableState<T, S, E, C> parent = this.getParentState();
            boolean bl = shouldUpdateHistoricalState = parent.getHistoryType() != HistoryType.NONE;
            if (!shouldUpdateHistoricalState) {
                for (ImmutableState<T, S, E, C> iter = parent.getParentState(); iter != null; iter = iter.getParentState()) {
                    if (iter.getHistoryType() != HistoryType.DEEP) continue;
                    shouldUpdateHistoricalState = true;
                    break;
                }
            }
            if (shouldUpdateHistoricalState) {
                stateContext.getStateMachineData().write().lastActiveChildStateFor(this.getParentState().getStateId(), this.getStateId());
            }
            if (this.getParentState().isRegion()) {
                S grandParentId = this.getParentState().getParentState().getStateId();
                stateContext.getStateMachineData().write().removeSubState(grandParentId, this.getStateId());
            }
        }
        logger.debug("State \"" + this.getStateId() + "\" exit.");
    }

    @Override
    public ImmutableState<T, S, E, C> getParentState() {
        return this.parentState;
    }

    @Override
    public List<ImmutableState<T, S, E, C>> getChildStates() {
        return Lists.newArrayList(this.childStates);
    }

    @Override
    public boolean hasChildStates() {
        return this.childStates != null && this.childStates.size() > 0;
    }

    @Override
    public void setParentState(MutableState<T, S, E, C> parent) {
        if (this == parent) {
            throw new IllegalArgumentException("parent state cannot be state itself.");
        }
        if (this.parentState != null) {
            throw new UnsupportedOperationException("Cannot change state parent.");
        }
        this.parentState = parent;
        this.setLevel(this.parentState != null ? this.parentState.getLevel() + 1 : 1);
    }

    @Override
    public ImmutableState<T, S, E, C> getInitialState() {
        return this.childInitialState;
    }

    @Override
    public void setInitialState(MutableState<T, S, E, C> childInitialState) {
        if (this.isParallelState()) {
            logger.warn("Ignoring attempt to set initial state of parallel state group.");
            return;
        }
        if (this.childInitialState != null) {
            throw new UnsupportedOperationException("Cannot change child initial state.");
        }
        this.childInitialState = childInitialState;
    }

    @Override
    public ImmutableState<T, S, E, C> enterByHistory(StateContext<T, S, E, C> stateContext) {
        if (this.isFinalState() || this.isParallelState()) {
            return this;
        }
        ImmutableState<T, S, E, C> result = null;
        switch (this.historyType) {
            case NONE: {
                result = this.enterHistoryNone(stateContext);
                break;
            }
            case SHALLOW: {
                result = this.enterHistoryShallow(stateContext);
                break;
            }
            case DEEP: {
                result = this.enterHistoryDeep(stateContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HistoryType : " + (Object)((Object)this.historyType));
            }
        }
        return result;
    }

    @Override
    public ImmutableState<T, S, E, C> enterDeep(StateContext<T, S, E, C> stateContext) {
        this.entry(stateContext);
        ImmutableState<T, S, E, C> lastActiveState = this.getLastActiveChildStateOf(this, stateContext.getStateMachineData().read());
        return lastActiveState == null ? this : lastActiveState.enterDeep(stateContext);
    }

    @Override
    public ImmutableState<T, S, E, C> enterShallow(StateContext<T, S, E, C> stateContext) {
        this.entry(stateContext);
        return this.childInitialState != null ? this.childInitialState.enterShallow(stateContext) : this;
    }

    private ImmutableState<T, S, E, C> enterHistoryShallow(StateContext<T, S, E, C> stateContext) {
        ImmutableState<T, S, E, C> lastActiveState = this.getLastActiveChildStateOf(this, stateContext.getStateMachineData().read());
        return lastActiveState != null ? lastActiveState.enterShallow(stateContext) : this;
    }

    private ImmutableState<T, S, E, C> enterHistoryNone(StateContext<T, S, E, C> stateContext) {
        return this.childInitialState != null ? this.childInitialState.enterShallow(stateContext) : this;
    }

    private ImmutableState<T, S, E, C> enterHistoryDeep(StateContext<T, S, E, C> stateContext) {
        ImmutableState<T, S, E, C> lastActiveState = this.getLastActiveChildStateOf(this, stateContext.getStateMachineData().read());
        return lastActiveState != null ? lastActiveState.enterDeep(stateContext) : this;
    }

    private LinkedListMultimap<E, ImmutableTransition<T, S, E, C>> getTransitions() {
        if (this.transitions == null) {
            this.transitions = LinkedListMultimap.create();
        }
        return this.transitions;
    }

    @Override
    public MutableTransition<T, S, E, C> addTransitionOn(E event) {
        MutableTransition newTransition = FSM.newTransition();
        newTransition.setSourceState(this);
        newTransition.setEvent(event);
        this.getTransitions().put(event, newTransition);
        return newTransition;
    }

    @Override
    public void addEntryAction(Action<T, S, E, C> newAction) {
        this.entryActions.add(newAction);
    }

    @Override
    public void addEntryActions(List<? extends Action<T, S, E, C>> newActions) {
        this.entryActions.addAll(newActions);
    }

    @Override
    public void addExitAction(Action<T, S, E, C> newAction) {
        this.exitActions.add(newAction);
    }

    @Override
    public void addExitActions(List<? extends Action<T, S, E, C>> newActions) {
        this.exitActions.addAll(newActions);
    }

    private boolean isParentOf(ImmutableState<T, S, E, C> state) {
        for (ImmutableState<T, S, E, C> parent = state.getParentState(); parent != null; parent = parent.getParentState()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public void internalFire(StateContext<T, S, E, C> stateContext) {
        TransitionResult<T, S, E, C> currentTransitionResult = stateContext.getResult();
        if (this.isParallelState()) {
            List<ImmutableState<T, S, E, C>> parallelStates = this.getSubStatesOn(this, stateContext.getStateMachineData().read());
            for (ImmutableState immutableState : parallelStates) {
                ImmutableState<T, S, E, C> parentState;
                ImmutableState<T, S, E, C> grandParentState;
                if (immutableState.isFinalState()) continue;
                TransitionResult<T, S, E, C> subTransitionResult = FSM.newResult(false, immutableState, currentTransitionResult);
                StateContext<T, S, E, C> subStateContext = FSM.newStateContext(stateContext.getStateMachine(), stateContext.getStateMachineData(), immutableState, stateContext.getEvent(), stateContext.getContext(), subTransitionResult, stateContext.getExecutor());
                immutableState.internalFire(subStateContext);
                if (subTransitionResult.isDeclined()) continue;
                if (!this.isParentOf(subTransitionResult.getTargetState())) {
                    currentTransitionResult.setTargetState(subTransitionResult.getTargetState());
                    return;
                }
                stateContext.getStateMachineData().write().subStateFor(this.getStateId(), subTransitionResult.getTargetState().getStateId());
                if (!subTransitionResult.getTargetState().isFinalState() || (grandParentState = (parentState = subTransitionResult.getTargetState().getParentState()).getParentState()) == null || !grandParentState.isParallelState()) continue;
                boolean allReachedFinal = true;
                for (ImmutableState<T, S, E, C> subState : this.getSubStatesOn(grandParentState, stateContext.getStateMachineData().read())) {
                    if (subState.isFinalState()) continue;
                    allReachedFinal = false;
                    break;
                }
                if (!allReachedFinal) continue;
                StateMachine stateMachine = stateContext.getStateMachine();
                AbstractStateMachine stateMachineImpl = (AbstractStateMachine)stateMachine;
                stateMachine.fireImmediate(stateMachineImpl.getFinishEvent(), stateContext.getContext());
                return;
            }
        }
        List<ImmutableTransition<T, S, E, C>> transitions = this.getTransitions(stateContext.getEvent());
        for (ImmutableTransition immutableTransition : transitions) {
            immutableTransition.internalFire(stateContext);
            if (!currentTransitionResult.isAccepted()) continue;
            ImmutableState<T, S, E, C> targetState = currentTransitionResult.getTargetState();
            if (targetState.isFinalState() && !targetState.isRootState()) {
                ImmutableState<T, S, E, C> parentState = targetState.getParentState();
                AbstractStateMachine abstractStateMachine = (AbstractStateMachine)stateContext.getStateMachine();
                StateContext<T, S, E, C> finishContext = FSM.newStateContext(stateContext.getStateMachine(), stateContext.getStateMachineData(), parentState, abstractStateMachine.getFinishEvent(), stateContext.getContext(), currentTransitionResult, stateContext.getExecutor());
                parentState.internalFire(finishContext);
            }
            return;
        }
        if (currentTransitionResult.isDeclined() && this.getParentState() != null && !this.getParentState().isRegion() && !this.getParentState().isParallelState()) {
            logger.debug("Internal notify the same event to parent state");
            this.getParentState().internalFire(stateContext);
        }
    }

    @Override
    public boolean isRootState() {
        return this.parentState == null;
    }

    @Override
    public boolean isFinalState() {
        return this.isFinalState;
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.isFinalState = isFinal;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitOnEntry(this);
        for (ImmutableTransition<T, S, E, C> immutableTransition : this.getAllTransitions()) {
            immutableTransition.accept(visitor);
        }
        if (this.childStates != null) {
            for (ImmutableState immutableState : this.childStates) {
                immutableState.accept(visitor);
            }
        }
        visitor.visitOnExit(this);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
        if (this.childStates != null) {
            for (MutableState<T, S, E, C> state : this.childStates) {
                state.setLevel(this.level + 1);
            }
        }
    }

    @Override
    public void addChildState(MutableState<T, S, E, C> childState) {
        if (childState != null) {
            if (this.childStates == null) {
                this.childStates = Lists.newArrayList();
            }
            if (!this.childStates.contains(childState)) {
                this.childStates.add(childState);
            }
        }
    }

    @Override
    public HistoryType getHistoryType() {
        return this.historyType;
    }

    @Override
    public void setHistoryType(HistoryType historyType) {
        this.historyType = historyType;
    }

    @Override
    public StateCompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public void setCompositeType(StateCompositeType compositeType) {
        this.compositeType = compositeType;
    }

    @Override
    public boolean isParallelState() {
        return this.compositeType == StateCompositeType.PARALLEL;
    }

    public String toString() {
        return this.getStateId().toString();
    }

    @Override
    public boolean isRegion() {
        return this.parentState != null && this.parentState.isParallelState();
    }

    @Override
    public void verify() {
        if (this.isFinalState()) {
            if (this.isParallelState()) {
                throw new IllegalStateException("Final state cannot be parallel state.");
            }
            if (this.hasChildStates()) {
                throw new IllegalStateException("Final state cannot have child states.");
            }
        }
        if (this.transitions != null) {
            List allTransitions = this.transitions.values();
            for (ImmutableTransition t : allTransitions) {
                t.verify();
                ImmutableTransition<T, S, E, C> conflictTransition = this.checkConflictTransitions(t, allTransitions);
                if (conflictTransition == null) continue;
                throw new RuntimeException(String.format("Transition '%s' is conflicted with '%s'.", t, conflictTransition));
            }
        }
    }

    public ImmutableTransition<T, S, E, C> checkConflictTransitions(ImmutableTransition<T, S, E, C> target, List<ImmutableTransition<T, S, E, C>> allTransitions) {
        for (ImmutableTransition<T, S, E, C> t : allTransitions) {
            if (target == t || t.getCondition().getClass() == Conditions.Never.class || !t.isMatch(target.getSourceState().getStateId(), target.getTargetState().getStateId(), target.getEvent(), target.getPriority())) continue;
            if (t.getCondition().getClass() == Conditions.Always.class) {
                return target;
            }
            if (target.getCondition().getClass() == Conditions.Always.class) {
                return target;
            }
            if (!t.getCondition().name().equals(target.getCondition().name())) continue;
            return target;
        }
        return null;
    }

    private List<ImmutableState<T, S, E, C>> getSubStatesOn(ImmutableState<T, S, E, C> parentState, StateMachineData.Reader<T, S, E, C> read) {
        ArrayList subStates = Lists.newArrayList();
        for (S stateId : read.subStatesOn(parentState.getStateId())) {
            subStates.add(read.rawStateFrom(stateId));
        }
        return subStates;
    }

    private ImmutableState<T, S, E, C> getLastActiveChildStateOf(ImmutableState<T, S, E, C> parentState, StateMachineData.Reader<T, S, E, C> read) {
        S childStateId = read.lastActiveChildStateOf(parentState.getStateId());
        if (childStateId != null) {
            return read.rawStateFrom(childStateId);
        }
        return parentState.getInitialState();
    }

    @Override
    public ImmutableState<T, S, E, C> getThis() {
        return this;
    }

    protected String getKey(T stateMachine) {
        return stateMachine.getIdentifier() + '@' + this.getPath();
    }

    @Override
    public String getPath() {
        String currentId = this.stateId.toString();
        if (this.parentState == null) {
            return currentId;
        }
        return this.parentState.getPath() + "/" + currentId;
    }

    @Override
    public boolean isChildStateOf(ImmutableState<T, S, E, C> input) {
        ImmutableState<T, S, E, C> curr = this;
        while (curr.getLevel() > input.getLevel()) {
            curr = curr.getParentState();
        }
        return curr == input;
    }
}

