/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.log4j.Logger;
import org.restcomm.media.bootstrap.configuration.ConfigurationLoader;
import org.restcomm.media.bootstrap.configuration.XmlConfigurationLoader;
import org.restcomm.media.bootstrap.ioc.AsrModule;
import org.restcomm.media.bootstrap.ioc.CoreModule;
import org.restcomm.media.bootstrap.ioc.MediaModule;
import org.restcomm.media.bootstrap.ioc.MgcpModule;
import org.restcomm.media.bootstrap.main.RestCommMediaServer;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.spi.MediaServer;

public class Bootstrapper {
    private static final Logger log = Logger.getLogger(Bootstrapper.class);
    private final String filepath;
    private final ConfigurationLoader configurationLoader;
    private MediaServer mediaServer;

    public Bootstrapper(String filepath) {
        this.filepath = filepath;
        this.configurationLoader = new XmlConfigurationLoader();
    }

    public void start() {
        try {
            MediaServerConfiguration conf = this.configurationLoader.load(this.filepath);
            Injector injector = Guice.createInjector((Module[])new Module[]{new CoreModule(conf), new MediaModule(), new MgcpModule(), new AsrModule()});
            this.mediaServer = (MediaServer)injector.getInstance(RestCommMediaServer.class);
            this.mediaServer.start();
        }
        catch (Exception e) {
            log.error((Object)("Bootstrap aborted. Reason: " + e.getMessage()));
        }
    }

    public void stop() {
        if (this.mediaServer != null) {
            this.mediaServer.stop();
        }
    }
}

