/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import org.restcomm.media.bootstrap.ioc.provider.AudioPlayerFactoryProvider;
import org.restcomm.media.bootstrap.ioc.provider.AudioPlayerPoolProvider;
import org.restcomm.media.bootstrap.ioc.provider.AudioRecorderFactoryProvider;
import org.restcomm.media.bootstrap.ioc.provider.AudioRecorderPoolProvider;
import org.restcomm.media.bootstrap.ioc.provider.CachedRemoteStreamProvider;
import org.restcomm.media.bootstrap.ioc.provider.DirectRemoteStreamProvider;
import org.restcomm.media.bootstrap.ioc.provider.DtlsSrtpServerProviderProvider;
import org.restcomm.media.bootstrap.ioc.provider.DtmfDetectorFactoryProvider;
import org.restcomm.media.bootstrap.ioc.provider.DtmfDetectorPoolProvider;
import org.restcomm.media.bootstrap.ioc.provider.DtmfGeneratorFactoryProvider;
import org.restcomm.media.bootstrap.ioc.provider.DtmfGeneratorPoolProvider;
import org.restcomm.media.bootstrap.ioc.provider.MediaSchedulerProvider;
import org.restcomm.media.bootstrap.ioc.provider.TaskSchedulerProvider;
import org.restcomm.media.bootstrap.ioc.provider.UdpManagerProvider;
import org.restcomm.media.bootstrap.ioc.provider.WallClockProvider;
import org.restcomm.media.bootstrap.ioc.provider.mgcp.Mgcp2ControllerProvider;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.network.deprecated.UdpManager;
import org.restcomm.media.resource.player.audio.RemoteStreamProvider;
import org.restcomm.media.rtp.crypto.DtlsSrtpServerProvider;
import org.restcomm.media.scheduler.Clock;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.spi.ServerManager;

public class CoreModule
extends AbstractModule {
    private final MediaServerConfiguration config;

    public CoreModule(MediaServerConfiguration config) {
        this.config = config;
    }

    protected void configure() {
        this.bind(MediaServerConfiguration.class).toInstance((Object)this.config);
        this.bind(Clock.class).toProvider(WallClockProvider.class).in(Singleton.class);
        this.bind(PriorityQueueScheduler.class).toProvider(MediaSchedulerProvider.class).in(Singleton.class);
        this.bind(Scheduler.class).toProvider(TaskSchedulerProvider.class).in(Singleton.class);
        this.bind(UdpManager.class).toProvider(UdpManagerProvider.class).in(Singleton.class);
        this.bind(AudioPlayerFactoryProvider.AudioPlayerFactoryType.INSTANCE).toProvider(AudioPlayerFactoryProvider.class).in(Singleton.class);
        this.bind(AudioPlayerPoolProvider.AudioPlayerPoolType.INSTANCE).toProvider(AudioPlayerPoolProvider.class).in(Singleton.class);
        this.bind(AudioRecorderFactoryProvider.AudioRecorderFactoryType.INSTANCE).toProvider(AudioRecorderFactoryProvider.class).in(Singleton.class);
        this.bind(AudioRecorderPoolProvider.AudioRecorderPoolType.INSTANCE).toProvider(AudioRecorderPoolProvider.class).in(Singleton.class);
        this.bind(DtmfDetectorFactoryProvider.DtmfDetectorFactoryType.INSTANCE).toProvider(DtmfDetectorFactoryProvider.class).in(Singleton.class);
        this.bind(DtmfDetectorPoolProvider.DtmfDetectorPoolType.INSTANCE).toProvider(DtmfDetectorPoolProvider.class).in(Singleton.class);
        this.bind(DtmfGeneratorFactoryProvider.DtmfGeneratorFactoryType.INSTANCE).toProvider(DtmfGeneratorFactoryProvider.class).in(Singleton.class);
        this.bind(DtmfGeneratorPoolProvider.DtmfGeneratorPoolType.INSTANCE).toProvider(DtmfGeneratorPoolProvider.class).in(Singleton.class);
        this.bind(ServerManager.class).toProvider(Mgcp2ControllerProvider.class).in(Singleton.class);
        this.bind(DtlsSrtpServerProvider.class).toProvider(DtlsSrtpServerProviderProvider.class).in(Singleton.class);
        Class remoteStreamProvider = this.config.getResourcesConfiguration().getPlayerCacheEnabled() ? CachedRemoteStreamProvider.class : DirectRemoteStreamProvider.class;
        this.bind(RemoteStreamProvider.class).toProvider(remoteStreamProvider).in(Singleton.class);
    }
}

