/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.resource.dtmf.DtmfGeneratorFactory;
import org.restcomm.media.resource.dtmf.GeneratorImpl;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.pooling.PooledObjectFactory;

public class DtmfGeneratorFactoryProvider
implements Provider<DtmfGeneratorFactory> {
    private final MediaServerConfiguration config;
    private final PriorityQueueScheduler mediaScheduler;

    @Inject
    public DtmfGeneratorFactoryProvider(MediaServerConfiguration config, PriorityQueueScheduler mediaScheduler) {
        this.config = config;
        this.mediaScheduler = mediaScheduler;
    }

    public DtmfGeneratorFactory get() {
        int duration = this.config.getResourcesConfiguration().getDtmfGeneratorToneDuration();
        int volume = this.config.getResourcesConfiguration().getDtmfGeneratorToneVolume();
        return new DtmfGeneratorFactory(this.mediaScheduler, volume, duration);
    }

    public static final class DtmfGeneratorFactoryType
    extends TypeLiteral<PooledObjectFactory<GeneratorImpl>> {
        public static final DtmfGeneratorFactoryType INSTANCE = new DtmfGeneratorFactoryType();

        private DtmfGeneratorFactoryType() {
        }
    }
}

