/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.network.deprecated.PortManager;
import org.restcomm.media.network.deprecated.RtpPortManager;
import org.restcomm.media.network.deprecated.UdpManager;
import org.restcomm.media.scheduler.Scheduler;

public class UdpManagerProvider
implements Provider<UdpManager> {
    private final Scheduler scheduler;
    private final MediaServerConfiguration config;
    private final PortManager portManager;
    private final PortManager localPortManager;

    @Inject
    public UdpManagerProvider(MediaServerConfiguration config, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.config = config;
        this.portManager = new RtpPortManager(config.getMediaConfiguration().getLowPort(), config.getMediaConfiguration().getHighPort());
        this.localPortManager = new RtpPortManager();
    }

    public UdpManager get() {
        UdpManager udpManager = new UdpManager(this.scheduler, this.portManager, this.localPortManager);
        udpManager.setBindAddress(this.config.getNetworkConfiguration().getBindAddress());
        udpManager.setLocalBindAddress(this.config.getControllerConfiguration().getAddress());
        udpManager.setExternalAddress(this.config.getNetworkConfiguration().getExternalAddress());
        udpManager.setLocalNetwork(this.config.getNetworkConfiguration().getNetwork());
        udpManager.setLocalSubnet(this.config.getNetworkConfiguration().getSubnet());
        udpManager.setUseSbc(Boolean.valueOf(this.config.getNetworkConfiguration().isSbc()));
        udpManager.setRtpTimeout(this.config.getMediaConfiguration().getTimeout());
        return udpManager;
    }
}

