/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider.asr;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.restcomm.media.asr.AsrEngineProvider;
import org.restcomm.media.asr.AsrEngineProviderImpl;
import org.restcomm.media.asr.driver.AsrDriverManagerImpl;
import org.restcomm.media.core.configuration.DriverConfiguration;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.core.configuration.SubsystemsConfiguration;
import org.restcomm.media.drivers.asr.AsrDriverManager;
import org.restcomm.media.scheduler.PriorityQueueScheduler;

public class AsrEngineProviderGuiceProvider
implements Provider<AsrEngineProvider> {
    private static final Logger logger = Logger.getLogger(AsrEngineProviderGuiceProvider.class);
    private final PriorityQueueScheduler scheduler;
    private final MediaServerConfiguration configuration;

    @Inject
    public AsrEngineProviderGuiceProvider(PriorityQueueScheduler scheduler, MediaServerConfiguration configuration) {
        this.scheduler = scheduler;
        this.configuration = configuration;
    }

    public AsrEngineProvider get() {
        AsrDriverManagerImpl mng = new AsrDriverManagerImpl();
        SubsystemsConfiguration subsystemsConfiguration = this.configuration.getSubsystemsConfiguration();
        Collection drivers = subsystemsConfiguration.getDrivers("asr");
        if (drivers == null || drivers.isEmpty()) {
            logger.warn((Object)"Asr drivers are not configured. Speech recognition functionality will not work");
        } else {
            for (DriverConfiguration driver : drivers) {
                String driverName = driver.getDriverName();
                String className = driver.getClassName();
                mng.registerDriver(driverName, className, driver.getParameters());
                logger.info((Object)("Driver '" + driverName + "' (" + className + ") is successfully registered"));
            }
        }
        int silenceLevel = this.configuration.getResourcesConfiguration().getSpeechDetectorSilenceLevel();
        return new AsrEngineProviderImpl(this.scheduler, (AsrDriverManager)mng, silenceLevel);
    }
}

