/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider.mgcp;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.restcomm.media.control.mgcp.connection.MgcpConnectionProvider;
import org.restcomm.media.control.mgcp.pkg.MgcpEventProvider;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.rtp.ChannelsManager;
import org.restcomm.media.rtp.channels.MediaChannelProvider;

public class MgcpConnectionProviderProvider
implements Provider<MgcpConnectionProvider> {
    private final MediaServerConfiguration configuration;
    private final MediaChannelProvider mediaChannelProvider;
    private final ChannelsManager channelsManager;
    private final ListeningScheduledExecutorService executor;
    private final MgcpEventProvider eventProvider;

    @Inject
    public MgcpConnectionProviderProvider(MediaServerConfiguration configuration, MgcpEventProvider eventProvider, MediaChannelProvider mediaChannelProvider, ChannelsManager channelsManager, ListeningScheduledExecutorService executor) {
        this.configuration = configuration;
        this.eventProvider = eventProvider;
        this.mediaChannelProvider = mediaChannelProvider;
        this.channelsManager = channelsManager;
        this.executor = executor;
    }

    public MgcpConnectionProvider get() {
        int timeout = this.configuration.getMediaConfiguration().getMaxDuration();
        return new MgcpConnectionProvider(timeout, this.eventProvider, this.mediaChannelProvider, this.channelsManager, this.executor);
    }
}

