/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider.mgcp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restcomm.media.control.mgcp.connection.MgcpConnectionProvider;
import org.restcomm.media.control.mgcp.endpoint.MgcpEndpoint;
import org.restcomm.media.control.mgcp.endpoint.provider.MediaGroupProvider;
import org.restcomm.media.control.mgcp.endpoint.provider.MgcpEndpointProvider;
import org.restcomm.media.control.mgcp.endpoint.provider.MgcpMixerEndpointProvider;
import org.restcomm.media.control.mgcp.endpoint.provider.MgcpSplitterEndpointProvider;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.core.configuration.MgcpControllerConfiguration;
import org.restcomm.media.core.configuration.MgcpEndpointConfiguration;
import org.restcomm.media.scheduler.PriorityQueueScheduler;

public class MgcpEndpointInstallerProvider
implements Provider<List<MgcpEndpointProvider<? extends MgcpEndpoint>>> {
    private final MediaServerConfiguration configuration;
    private final PriorityQueueScheduler mediaScheduler;
    private final MgcpConnectionProvider connectionProvider;
    private final MediaGroupProvider MediaGroupProvider;

    @Inject
    public MgcpEndpointInstallerProvider(MediaServerConfiguration configuration, PriorityQueueScheduler mediaScheduler, MgcpConnectionProvider connectionProvider, MediaGroupProvider mediaGroupProvider) {
        this.configuration = configuration;
        this.mediaScheduler = mediaScheduler;
        this.connectionProvider = connectionProvider;
        this.MediaGroupProvider = mediaGroupProvider;
    }

    public List<MgcpEndpointProvider<? extends MgcpEndpoint>> get() {
        MgcpControllerConfiguration controller = this.configuration.getControllerConfiguration();
        Iterator iterator = controller.getEndpoints();
        ArrayList<MgcpEndpointProvider<? extends MgcpEndpoint>> providers = new ArrayList<MgcpEndpointProvider<? extends MgcpEndpoint>>(controller.countEndpoints());
        String domain = this.configuration.getControllerConfiguration().getAddress() + ":" + this.configuration.getControllerConfiguration().getPort();
        while (iterator.hasNext()) {
            MgcpMixerEndpointProvider provider;
            MgcpEndpointConfiguration endpoint = (MgcpEndpointConfiguration)iterator.next();
            String namespace = endpoint.getName();
            switch (endpoint.getRelayType()) {
                case MIXER: {
                    provider = new MgcpMixerEndpointProvider(namespace, domain, this.mediaScheduler, this.connectionProvider, this.MediaGroupProvider);
                    break;
                }
                case SPLITTER: {
                    provider = new MgcpSplitterEndpointProvider(namespace, domain, this.mediaScheduler, this.connectionProvider, this.MediaGroupProvider);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown relay type " + endpoint.getRelayType());
                }
            }
            providers.add((MgcpEndpointProvider<? extends MgcpEndpoint>)provider);
        }
        return providers;
    }

    public static final class MgcpEndpointInstallerListType
    extends TypeLiteral<List<MgcpEndpointProvider<? extends MgcpEndpoint>>> {
        public static final MgcpEndpointInstallerListType INSTANCE = new MgcpEndpointInstallerListType();

        private MgcpEndpointInstallerListType() {
        }
    }
}

