/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.main;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.UdpManager;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.spi.ControlProtocol;
import org.restcomm.media.spi.MediaServer;
import org.restcomm.media.spi.ServerManager;

public class RestCommMediaServer
implements MediaServer {
    private static final Logger log = Logger.getLogger(RestCommMediaServer.class);
    private boolean started;
    private Map<ControlProtocol, ServerManager> controllers;
    private final PriorityQueueScheduler mediaScheduler;
    private final Scheduler taskScheduler;
    private final UdpManager udpManager;
    private final HeartBeat heartbeat;
    private final int heartbeatTime;
    private volatile long ttl;

    @Inject
    public RestCommMediaServer(PriorityQueueScheduler mediaScheduler, Scheduler taskScheduler, UdpManager udpManager, ServerManager controller) {
        this.mediaScheduler = mediaScheduler;
        this.taskScheduler = taskScheduler;
        this.udpManager = udpManager;
        this.started = false;
        this.controllers = new HashMap<ControlProtocol, ServerManager>(2);
        this.addManager(controller);
        this.heartbeat = new HeartBeat();
        this.heartbeatTime = 1;
    }

    public void addManager(ServerManager manager) {
        if (manager != null) {
            ControlProtocol protocol = manager.getControlProtocol();
            if (this.controllers.containsKey(protocol)) {
                throw new IllegalArgumentException(protocol + " controller is already registered");
            }
            this.controllers.put(protocol, manager);
        }
    }

    public void removeManager(ServerManager manager) {
        if (manager != null) {
            this.controllers.remove(manager.getControlProtocol());
        }
    }

    public void start() throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("Media Server already started.");
        }
        this.started = true;
        this.heartbeat.restart();
        this.mediaScheduler.start();
        this.taskScheduler.start();
        this.udpManager.start();
        for (ServerManager controller : this.controllers.values()) {
            controller.activate();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Media Server started");
        }
    }

    public void stop() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("Media Server already stopped.");
        }
        this.started = false;
        this.udpManager.stop();
        this.taskScheduler.stop();
        this.mediaScheduler.stop();
        this.heartbeat.cancel();
        for (ServerManager controller : this.controllers.values()) {
            controller.deactivate();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Media Server stopped");
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    private final class HeartBeat
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.HEARTBEAT_QUEUE;
        }

        public void restart() {
            RestCommMediaServer.this.ttl = RestCommMediaServer.this.heartbeatTime * 600;
            RestCommMediaServer.this.mediaScheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            RestCommMediaServer.this.ttl--;
            if (RestCommMediaServer.this.ttl == 0L) {
                log.info((Object)"Global hearbeat is still alive");
                this.restart();
            } else {
                RestCommMediaServer.this.mediaScheduler.submitHeatbeat((Task)this);
            }
            return 0L;
        }
    }
}

