/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.resource.dtmf.DetectorImpl;
import org.restcomm.media.resource.dtmf.DtmfDetectorFactory;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.pooling.PooledObjectFactory;

public class DtmfDetectorFactoryProvider
implements Provider<DtmfDetectorFactory> {
    private final PriorityQueueScheduler mediaScheduler;
    private final MediaServerConfiguration configuration;

    @Inject
    public DtmfDetectorFactoryProvider(MediaServerConfiguration configuration, PriorityQueueScheduler mediaScheduler) {
        this.mediaScheduler = mediaScheduler;
        this.configuration = configuration;
    }

    public DtmfDetectorFactory get() {
        int volume = this.configuration.getResourcesConfiguration().getDtmfDetectorDbi();
        int duration = this.configuration.getResourcesConfiguration().getDtmfDetectorToneDuration();
        int interval = this.configuration.getResourcesConfiguration().getDtmfDetectorToneInterval();
        return new DtmfDetectorFactory(this.mediaScheduler, volume, duration, interval);
    }

    public static final class DtmfDetectorFactoryType
    extends TypeLiteral<PooledObjectFactory<DetectorImpl>> {
        public static final DtmfDetectorFactoryType INSTANCE = new DtmfDetectorFactoryType();

        private DtmfDetectorFactoryType() {
        }
    }
}

