/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import org.restcomm.media.component.dsp.DspFactoryImpl;
import org.restcomm.media.core.configuration.CodecType;
import org.restcomm.media.core.configuration.MediaServerConfiguration;

public class DspProvider
implements Provider<DspFactoryImpl> {
    private final MediaServerConfiguration config;

    @Inject
    public DspProvider(MediaServerConfiguration config) {
        this.config = config;
    }

    public DspFactoryImpl get() {
        DspFactoryImpl dsp = new DspFactoryImpl();
        Iterator codecs = this.config.getMediaConfiguration().getCodecs();
        while (codecs.hasNext()) {
            CodecType codec = CodecType.fromName((String)((String)codecs.next()));
            if (codec == null || codec.getEncoder().isEmpty() || codec.getDecoder().isEmpty()) continue;
            dsp.addCodec(codec.getDecoder());
            dsp.addCodec(codec.getEncoder());
        }
        return dsp;
    }
}

