/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Provider;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ListeningScheduledExecutorServiceProvider
implements Provider<ListeningScheduledExecutorService> {
    private static final int POOL_SIZE = Runtime.getRuntime().availableProcessors();

    public ListeningScheduledExecutorService get() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("mgcp-%d").build();
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(POOL_SIZE, threadFactory);
        executor.prestartAllCoreThreads();
        executor.setRemoveOnCancelPolicy(true);
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)executor);
    }
}

