/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider.mgcp;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.util.concurrent.Executor;
import org.restcomm.media.control.mgcp.network.netty.MgcpChannelInitializer;
import org.restcomm.media.control.mgcp.network.netty.MgcpNetworkManager;

public class MgcpNetworkManagerProvider
implements Provider<MgcpNetworkManager> {
    private final Bootstrap bootstrap;
    private final EventLoopGroup eventLoopGroup;
    private final MgcpChannelInitializer initializer;

    @Inject
    public MgcpNetworkManagerProvider(ListeningScheduledExecutorService executor, MgcpChannelInitializer initializer) {
        this.eventLoopGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), (Executor)executor);
        this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(NioDatagramChannel.class)).group(this.eventLoopGroup);
        this.initializer = initializer;
    }

    public MgcpNetworkManager get() {
        return new MgcpNetworkManager(this.bootstrap, this.initializer);
    }
}

