/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.configuration;

import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.log4j.Logger;
import org.restcomm.media.bootstrap.configuration.ConfigurationLoader;
import org.restcomm.media.core.configuration.DtlsConfiguration;
import org.restcomm.media.core.configuration.MediaConfiguration;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.core.configuration.MgcpControllerConfiguration;
import org.restcomm.media.core.configuration.MgcpEndpointConfiguration;
import org.restcomm.media.core.configuration.NetworkConfiguration;
import org.restcomm.media.core.configuration.ResourcesConfiguration;

public class XmlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger log = Logger.getLogger(XmlConfigurationLoader.class);
    private static final String MMS_HOME = "mms.home.dir";
    private static final String DEFAULT_PATH = "/conf/mediaserver.xml";
    private final Configurations configurations = new Configurations();

    @Override
    public MediaServerConfiguration load(String filepath) throws Exception {
        XMLConfiguration xml;
        MediaServerConfiguration configuration = new MediaServerConfiguration();
        try {
            xml = this.configurations.xml(filepath);
        }
        catch (ConfigurationException e) {
            log.warn((Object)("Could not load configuration from " + filepath));
            String mmsHome = System.getProperty(MMS_HOME);
            filepath = mmsHome + DEFAULT_PATH;
            xml = this.configurations.xml(filepath);
            log.warn((Object)("Configuration file found at " + filepath));
        }
        XmlConfigurationLoader.configureNetwork((HierarchicalConfiguration<ImmutableNode>)xml.configurationAt("network"), configuration.getNetworkConfiguration());
        XmlConfigurationLoader.configureController((HierarchicalConfiguration<ImmutableNode>)xml.configurationAt("controller"), configuration.getControllerConfiguration());
        XmlConfigurationLoader.configureMedia((HierarchicalConfiguration<ImmutableNode>)xml.configurationAt("media"), configuration.getMediaConfiguration());
        XmlConfigurationLoader.configureResource((HierarchicalConfiguration<ImmutableNode>)xml.configurationAt("resources"), configuration.getResourcesConfiguration());
        XmlConfigurationLoader.configureDtls((HierarchicalConfiguration<ImmutableNode>)xml.configurationAt("dtls"), configuration.getDtlsConfiguration());
        return configuration;
    }

    private static void configureNetwork(HierarchicalConfiguration<ImmutableNode> src, NetworkConfiguration dst) {
        dst.setBindAddress(src.getString("bindAddress", "127.0.0.1"));
        dst.setExternalAddress(src.getString("externalAddress", ""));
        dst.setNetwork(src.getString("network", "127.0.0.1"));
        dst.setSubnet(src.getString("subnet", "255.255.255.255"));
        dst.setSbc(src.getBoolean("sbc", false));
    }

    private static void configureController(HierarchicalConfiguration<ImmutableNode> src, MgcpControllerConfiguration dst) {
        dst.setAddress(src.getString("address", "127.0.0.1"));
        dst.setPort(src.getInt("port", 2427));
        List endpoints = src.childConfigurationsAt("endpoints");
        for (HierarchicalConfiguration endpoint : endpoints) {
            MgcpEndpointConfiguration endpointConfig = new MgcpEndpointConfiguration();
            endpointConfig.setName(endpoint.getString("[@name]"));
            endpointConfig.setRelayType(endpoint.getString("[@relay]", "mixer"));
            dst.addEndpoint(endpointConfig);
        }
    }

    private static void configureMedia(HierarchicalConfiguration<ImmutableNode> src, MediaConfiguration dst) {
        dst.setMaxDuration(src.getInt("maxDuration", 14400));
        dst.setTimeout(src.getInt("timeout", 0));
        dst.setLowPort(src.getInt("lowPort", 64534));
        dst.setHighPort(src.getInt("highPort", 65534));
        dst.setJitterBufferSize(src.getInt("jitterBuffer[@size]", 50));
        List codecs = src.childConfigurationsAt("codecs");
        for (HierarchicalConfiguration codec : codecs) {
            dst.addCodec(codec.getString("[@name]"));
        }
    }

    private static void configureResource(HierarchicalConfiguration<ImmutableNode> src, ResourcesConfiguration dst) {
        dst.setDtmfDetectorDbi(src.getInt("dtmfDetector[@dbi]", -35));
        dst.setDtmfDetectorToneDuration(src.getInt("dtmfDetector[@toneDuration]", 100));
        dst.setDtmfGeneratorToneVolume(src.getInt("dtmfGenerator[@toneVolume]", -20));
        dst.setDtmfGeneratorToneDuration(src.getInt("dtmfGenerator[@toneDuration]", 80));
        XmlConfigurationLoader.configurePlayer(src, dst);
    }

    private static void configureDtls(HierarchicalConfiguration<ImmutableNode> src, DtlsConfiguration dst) {
        dst.setMinVersion(src.getString("minVersion", "1.0"));
        dst.setMaxVersion(src.getString("maxVersion", "1.2"));
        dst.setCipherSuites(src.getString("cipherSuites", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"));
        dst.setCertificatePath(src.getString("certificate[@path]", "../conf/dtls/x509-server-ecdsa.pem"));
        dst.setKeyPath(src.getString("certificate[@key]", "../conf/dtls/x509-server-key-ecdsa.pem"));
        dst.setAlgorithmCertificate(src.getString("certificate[@algorithm]", DtlsConfiguration.ALGORITHM_CERTIFICATE));
    }

    private static void configurePlayer(HierarchicalConfiguration<ImmutableNode> src, ResourcesConfiguration dst) {
        HierarchicalConfiguration cache;
        HierarchicalConfiguration player = src.configurationAt("player");
        try {
            cache = player.configurationAt("cache");
        }
        catch (ConfigurationRuntimeException exception) {
            log.info((Object)"No cache was specified for player");
            return;
        }
        dst.setPlayerCache(cache.getBoolean("cacheEnabled", false), cache.getInt("cacheSize", 0));
    }
}

