/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider.media;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.resource.dtmf.DetectorProvider;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.dtmf.DtmfDetectorProvider;

public class DtmfDetectorProviderProvider
implements Provider<DtmfDetectorProvider> {
    private final PriorityQueueScheduler scheduler;
    private final MediaServerConfiguration configuration;

    @Inject
    public DtmfDetectorProviderProvider(PriorityQueueScheduler scheduler, MediaServerConfiguration configuration) {
        this.scheduler = scheduler;
        this.configuration = configuration;
    }

    public DtmfDetectorProvider get() {
        int volume = this.configuration.getResourcesConfiguration().getDtmfDetectorDbi();
        int duration = this.configuration.getResourcesConfiguration().getDtmfDetectorToneDuration();
        int interval = this.configuration.getResourcesConfiguration().getDtmfDetectorToneInterval();
        return new DetectorProvider(this.scheduler, volume, duration, interval);
    }
}

