/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import org.restcomm.media.resource.player.audio.AudioPlayerFactory;
import org.restcomm.media.resource.player.audio.AudioPlayerImpl;
import org.restcomm.media.resource.player.audio.RemoteStreamProvider;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.dsp.DspFactory;
import org.restcomm.media.spi.pooling.PooledObjectFactory;

public class AudioPlayerFactoryProvider
implements Provider<AudioPlayerFactory> {
    private final PriorityQueueScheduler mediaScheduler;
    private final DspFactory dspFactory;
    private final RemoteStreamProvider remoteStreamProvider;

    @Inject
    public AudioPlayerFactoryProvider(PriorityQueueScheduler mediaScheduler, DspFactory dspFactory, RemoteStreamProvider remoteStreamProvider) {
        this.mediaScheduler = mediaScheduler;
        this.dspFactory = dspFactory;
        this.remoteStreamProvider = remoteStreamProvider;
    }

    public AudioPlayerFactory get() {
        return new AudioPlayerFactory(this.mediaScheduler, this.dspFactory, this.remoteStreamProvider);
    }

    public static final class AudioPlayerFactoryType
    extends TypeLiteral<PooledObjectFactory<AudioPlayerImpl>> {
        public static final AudioPlayerFactoryType INSTANCE = new AudioPlayerFactoryType();

        private AudioPlayerFactoryType() {
        }
    }
}

