/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.bootstrap.ioc.provider.media;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import org.restcomm.media.core.configuration.CodecType;
import org.restcomm.media.core.configuration.MediaServerConfiguration;
import org.restcomm.media.network.deprecated.UdpManager;
import org.restcomm.media.rtp.ChannelsManager;
import org.restcomm.media.rtp.crypto.DtlsSrtpServerProvider;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.sdp.format.AVProfile;
import org.restcomm.media.sdp.format.RTPFormat;
import org.restcomm.media.sdp.format.RTPFormats;

public class ChannelsManagerProvider
implements Provider<ChannelsManager> {
    private final UdpManager udpManager;
    private final PriorityQueueScheduler mediaScheduler;
    private final MediaServerConfiguration config;
    private final DtlsSrtpServerProvider dtlsServerProvider;
    private final RTPFormats supportedCodecs;

    @Inject
    public ChannelsManagerProvider(MediaServerConfiguration config, UdpManager udpManager, PriorityQueueScheduler mediaScheduler, DtlsSrtpServerProvider dtlsServerProvider) {
        this.udpManager = udpManager;
        this.mediaScheduler = mediaScheduler;
        this.config = config;
        this.dtlsServerProvider = dtlsServerProvider;
        this.supportedCodecs = new RTPFormats(this.config.getMediaConfiguration().countCodecs());
        Iterator codecs = this.config.getMediaConfiguration().getCodecs();
        while (codecs.hasNext()) {
            RTPFormat format;
            CodecType codec = CodecType.fromName((String)((String)codecs.next()));
            if (codec == null || (format = AVProfile.audio.find(codec.getPayloadType())) == null) continue;
            this.supportedCodecs.add(format);
        }
    }

    public ChannelsManager get() {
        ChannelsManager channelsManager = new ChannelsManager(this.udpManager, this.supportedCodecs, this.dtlsServerProvider);
        channelsManager.setScheduler(this.mediaScheduler);
        channelsManager.setJitterBufferSize(this.config.getMediaConfiguration().getJitterBufferSize());
        return channelsManager;
    }
}

