/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import org.restcomm.javax.media.mscontrol.ParameterImpl;
import org.restcomm.javax.media.mscontrol.ParametersImpl;
import org.restcomm.javax.media.mscontrol.spi.DriverImpl;

public abstract class MediaObjectImpl
implements MediaObject {
    public static final Parameter ENDPOINT_NAME = ParameterImpl.create("ENDPOINT_NAME");
    private static int GENERATOR = 0;
    private URI uri;
    private MediaObjectImpl parent;
    private DriverImpl driver;
    private Parameters parameters = new ParametersImpl();
    private ArrayList<String> IDs = new ArrayList();
    private String objectID;

    public MediaObjectImpl(MediaObjectImpl parent, DriverImpl driver, Parameters parameters) throws MsControlException {
        this.parent = parent;
        this.driver = driver;
        if (parameters != null) {
            this.parameters.putAll((Map)parameters);
        }
        String prefix = parent != null ? parent.getURI().toString() : "mscontrol://" + driver.getRemoteDomainName();
        String objectName = this.getClass().getSimpleName();
        if (objectName.endsWith("Impl")) {
            objectName = objectName.substring(0, objectName.length() - 4);
        }
        this.objectID = null;
        if (parameters != null) {
            this.objectID = (String)parameters.get((Object)MEDIAOBJECT_ID);
        }
        if (this.objectID == null) {
            this.objectID = objectName + ++GENERATOR;
        }
        if (!Character.isLetterOrDigit(this.objectID.charAt(0)) && this.objectID.charAt(0) != '/') {
            throw new MsControlException("Illegal MEDIAOBJECT_ID: " + this.objectID);
        }
        if (parent != null && parent.IDs.contains(this.objectID)) {
            throw new MsControlException("MEDIAOBJECT_ID must be unique: " + this.objectID);
        }
        String localName = null;
        if (parameters != null) {
            localName = (String)parameters.get((Object)ENDPOINT_NAME);
        }
        if (localName == null) {
            localName = this.objectID;
        }
        try {
            this.uri = new URI(prefix + "/" + this.objectID);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (parent != null) {
            parent.IDs.add(this.objectID);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public DriverImpl getDriver() {
        return this.driver;
    }

    public void setParameters(Parameters parameters) {
        this.parameters.clear();
        this.parameters.putAll((Map)parameters);
    }

    public Parameters getParameters(Parameter[] list) {
        ParametersImpl params = new ParametersImpl();
        for (Parameter p : list) {
            params.put(p, this.parameters.get((Object)p));
        }
        return params;
    }

    public Parameters createParameters() {
        return new ParametersImpl();
    }

    public void info(String s) {
        if (this.parent != null) {
            this.driver.info(String.format("%s %s %s", this.parent.objectID, this.objectID, s));
        } else {
            this.driver.info(String.format("%s %s", this.objectID, s));
        }
    }

    public void debug(String s) {
        if (this.parent != null) {
            this.driver.debug(String.format("%s %s %s", this.parent.objectID, this.objectID, s));
        } else {
            this.driver.debug(String.format("%s %s", this.objectID, s));
        }
    }

    public void warn(String s) {
        if (this.parent != null) {
            this.driver.warn(String.format("%s %s %s", this.parent.objectID, this.objectID, s));
        } else {
            this.driver.warn(String.format("%s %s", this.objectID, s));
        }
    }

    public String getObjectID() {
        return this.objectID;
    }

    public String toString() {
        return this.objectID;
    }
}

