/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol.container;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.join.JoinableStream;
import org.restcomm.fsm.FSM;
import org.restcomm.fsm.UnknownTransitionException;
import org.restcomm.javax.media.mscontrol.MediaConfigImpl;
import org.restcomm.javax.media.mscontrol.MediaObjectImpl;
import org.restcomm.javax.media.mscontrol.MediaSessionImpl;
import org.restcomm.javax.media.mscontrol.container.Endpoint;
import org.restcomm.javax.media.mscontrol.container.InvocationLock;
import org.restcomm.javax.media.mscontrol.container.JoinEventImpl;
import org.restcomm.javax.media.mscontrol.container.Link;
import org.restcomm.javax.media.mscontrol.container.LinkListener;
import org.restcomm.javax.media.mscontrol.container.MediaStreamImpl;

public abstract class ContainerImpl
extends MediaObjectImpl
implements JoinableContainer,
LinkListener {
    protected MediaSessionImpl session = null;
    private CopyOnWriteArrayList<JoinEventListener> listeners = new CopyOnWriteArrayList();
    protected MediaStreamImpl[] streams = new MediaStreamImpl[2];
    private ArrayList<Link> links = new ArrayList();
    private ArrayList<Link> incomingLinks = new ArrayList();
    protected MediaConfigImpl config;
    protected int maxJoinees = 1;
    protected Endpoint endpoint;
    protected InvocationLock invocationLock = new InvocationLock();
    protected ReentrantLock lock = new ReentrantLock();
    protected Joinable.Direction direction;

    public ContainerImpl(MediaSessionImpl session, Parameters parameters) throws MsControlException {
        super(session, session.getDriver(), parameters);
        this.session = session;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setConcreteName(EndpointIdentifier endpoint) {
        this.endpoint.setConcreteName(endpoint);
    }

    public MediaSessionImpl getMediaSession() {
        return this.session;
    }

    public JoinableStream getJoinableStream(JoinableStream.StreamType value) throws MsControlException {
        for (MediaStreamImpl s : this.streams) {
            if (!s.getType().equals((Object)value)) continue;
            return s;
        }
        throw new MsControlException("Stream of type " + value + " is not supported");
    }

    public JoinableStream[] getJoinableStreams() throws MsControlException {
        return this.streams;
    }

    public Joinable[] getJoinees() throws MsControlException {
        int i = 0;
        Joinable[] joinees = new Joinable[this.links.size() + this.incomingLinks.size()];
        for (Link link : this.links) {
            joinees[i++] = link.getContainer(1);
        }
        for (Link link : this.incomingLinks) {
            joinees[i++] = link.getContainer(0);
        }
        return joinees;
    }

    public Joinable[] getJoinees(Joinable.Direction direction) throws MsControlException {
        int i = 0;
        Joinable[] joinees = new Joinable[this.links.size() + this.incomingLinks.size()];
        for (Link link : this.links) {
            if (!link.direction.equals((Object)direction)) continue;
            joinees[i++] = link.getContainer(1);
        }
        Joinable.Direction inverseDirection = this.inversion(direction);
        for (Link link : this.incomingLinks) {
            if (!link.direction.equals((Object)inverseDirection)) continue;
            joinees[i++] = link.getContainer(0);
        }
        return joinees;
    }

    public synchronized void addIncomingLink(Link toAdd) {
        if (toAdd.getContainer(1) != this) {
            return;
        }
        for (Link l : this.links) {
            if (l.getContainer(1) != toAdd.getContainer(0)) continue;
            return;
        }
        for (Link l : this.incomingLinks) {
            if (l.getContainer(0) != toAdd.getContainer(0)) continue;
            return;
        }
        this.incomingLinks.add(toAdd);
    }

    public synchronized void removeIncomingLink(Link toRemove) {
        this.incomingLinks.remove(toRemove);
    }

    public void join(Joinable.Direction direction, Joinable other) throws MsControlException {
        this.joinInitiate(direction, other, null);
        this.invocationLock.lock(5000L);
    }

    public synchronized void joinInitiate(Joinable.Direction direction, Joinable other, Serializable context) throws MsControlException {
        FSM link = null;
        Joinable.Direction oldDirection = null;
        for (Link l : this.links) {
            if (l.getContainer(1) != other) continue;
            oldDirection = l.direction;
            link = l;
            ((Link)link).direction = direction;
            ((Link)link).context = context;
            break;
        }
        if (link == null) {
            link = new Link(this.session.getDriver().getScheduler(), this, (ContainerImpl)other);
            ((Link)link).direction = direction;
            ((Link)link).context = context;
            ((Link)link).setListener(this);
            this.links.add((Link)link);
            ((ContainerImpl)other).addIncomingLink((Link)link);
        } else if (direction == Joinable.Direction.DUPLEX && oldDirection == Joinable.Direction.DUPLEX) {
            for (Link l : this.links) {
                if (l.getContainer(1) == other) continue;
                l.direction = Joinable.Direction.SEND;
                try {
                    l.signal("join");
                }
                catch (UnknownTransitionException e) {
                    throw new MsControlException("Wrong state");
                }
            }
        }
        try {
            link.signal("join");
        }
        catch (UnknownTransitionException e) {
            throw new MsControlException("Wrong state");
        }
    }

    private boolean hasLink(ContainerImpl other) {
        for (Link l : this.links) {
            if (l.getContainer(1) != other) continue;
            return true;
        }
        return false;
    }

    protected Link getLink(Joinable.Direction direction, ContainerImpl other) {
        Link link = null;
        for (Link l : this.links) {
            if (l.getContainer(1) != other) continue;
            link = l;
            break;
        }
        if (link == null) {
            link = new Link(this.session.getDriver().getScheduler(), this, other);
            link.direction = direction;
            link.setListener(this);
            this.links.add(link);
        }
        return link;
    }

    public void unjoin(Joinable other) throws MsControlException {
        this.debug(String.format("Synchronous unjoin start, other party = %s", ((MediaObjectImpl)other).getObjectID()));
        if (this.hasLink((ContainerImpl)other)) {
            this.unjoinInitiate(other, null);
            this.invocationLock.lock(5000L);
        } else {
            other.unjoin((Joinable)this);
        }
        this.debug(String.format("Synchronous unjoin completed, other party = %s", ((MediaObjectImpl)other).getObjectID()));
    }

    public synchronized void unjoinInitiate(Joinable other, Serializable context) throws MsControlException {
        this.info(String.format("Initiation of unjoin procedure, other party = %s", ((MediaObjectImpl)other).getObjectID()));
        if (((ContainerImpl)other).hasLink(this)) {
            other.unjoinInitiate((Joinable)this, context);
            return;
        }
        Link link = null;
        for (Link l : this.links) {
            if (l.getContainer(1) != other) continue;
            link = l;
            break;
        }
        if (link == null) {
            return;
        }
        this.links.remove(link);
        ((ContainerImpl)other).removeIncomingLink(link);
        try {
            link.signal("release");
        }
        catch (UnknownTransitionException e) {
            throw new MsControlException("Illegal state");
        }
    }

    private Joinable.Direction inversion(Joinable.Direction direction) {
        switch (direction) {
            case SEND: {
                return Joinable.Direction.RECV;
            }
            case RECV: {
                return Joinable.Direction.SEND;
            }
        }
        return Joinable.Direction.DUPLEX;
    }

    public void addListener(JoinEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JoinEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fire(JoinEvent event) {
        new Thread(new EventHandler(event)).start();
    }

    protected ContainerImpl getOwner() {
        return this;
    }

    @Override
    public String toString() {
        return this.getURI().toString();
    }

    protected void unjoin() throws MsControlException {
        Link[] list = new Link[this.links.size()];
        this.links.toArray(list);
        for (Link link : list) {
            try {
                link.signal("release");
            }
            catch (UnknownTransitionException e) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void joined(Link link) {
        JoinEventImpl evt = new JoinEventImpl(this, link.context, (Joinable)link.getContainer(1), JoinEvent.JOINED, true, MediaErr.NO_ERROR, null);
        this.fire(evt);
        this.invocationLock.release();
    }

    @Override
    public void unjoined(Link link) {
        JoinEventImpl evt = new JoinEventImpl(this, link.context, (Joinable)link.getContainer(1), JoinEvent.UNJOINED, true, MediaErr.NO_ERROR, null);
        this.invocationLock.release();
        this.fire(evt);
    }

    private class EventHandler
    implements Runnable {
        private JoinEvent event;

        public EventHandler(JoinEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            for (JoinEventListener s : ContainerImpl.this.listeners) {
                s.onEvent(this.event);
            }
        }
    }
}

