/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.fsm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.restcomm.fsm.Logger;
import org.restcomm.fsm.State;
import org.restcomm.fsm.Transition;
import org.restcomm.fsm.UnknownTransitionException;

public class FSM
implements Runnable,
Serializable {
    protected State start;
    protected State end;
    private HashMap<String, State> states = new HashMap();
    protected State state;
    private ReentrantLock lock = new ReentrantLock();
    private HashMap attributes = new HashMap();
    protected ScheduledExecutorService scheduler;
    protected ScheduledFuture timer;
    protected Logger logger;

    public FSM(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public State getState() {
        return this.state;
    }

    public void setStart(String name) {
        if (this.start != null && this.state != null) {
            throw new IllegalStateException("Start state can be changed now");
        }
        this.state = this.start = this.states.get(name);
    }

    public void setEnd(String name) {
        this.end = this.states.get(name);
    }

    public State createState(String name) {
        State s = new State(this, name);
        this.states.put(name, s);
        return s;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Transition createTransition(String name, String from, String to) {
        if (name.equals("timeout")) {
            throw new IllegalArgumentException("timeout is illegal name for transition");
        }
        if (!this.states.containsKey(from)) {
            throw new IllegalStateException("Unknown state: " + from);
        }
        if (!this.states.containsKey(to)) {
            throw new IllegalStateException("Unknown state: " + to);
        }
        Transition t = new Transition(name, this.states.get(to));
        this.states.get(from).add(t);
        return t;
    }

    public Transition createTimeoutTransition(String from, String to, long timeout) {
        if (!this.states.containsKey(from)) {
            throw new IllegalStateException("Unknown state: " + from);
        }
        if (!this.states.containsKey(to)) {
            throw new IllegalStateException("Unknown state: " + to);
        }
        Transition t = new Transition("timeout", this.states.get(to));
        this.states.get((Object)from).timeout = timeout;
        this.states.get(from).add(t);
        return t;
    }

    public synchronized void signal(String name) throws UnknownTransitionException {
        if (this.start == null) {
            throw new IllegalStateException("The start sate is not defined");
        }
        if (this.end == null) {
            throw new IllegalStateException("The end sate is not defined");
        }
        String old = this.state.getName();
        this.state = this.state.signal(name);
        if (this.logger != null) {
            this.logger.debug(String.format("current state=%s, signal=%s, transition to=%s", old, name, this.state.getName()));
        }
    }

    public void signalAsync(String name) {
        new Thread(new Executor(name)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        FSM fSM = this;
        synchronized (fSM) {
            if (this.state != null && this.state != this.start && this.state != this.end) {
                this.state.tick(System.currentTimeMillis());
            }
        }
    }

    private class Executor
    implements Runnable {
        private String signal;

        public Executor(String signal) {
            this.signal = signal;
        }

        @Override
        public void run() {
            try {
                FSM.this.signal(this.signal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

