/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol;

import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaConfigException;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.resource.video.VideoLayout;
import org.apache.log4j.Logger;
import org.restcomm.javax.media.mscontrol.MediaSessionImpl;
import org.restcomm.javax.media.mscontrol.ParametersImpl;
import org.restcomm.javax.media.mscontrol.XMLParser;
import org.restcomm.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.restcomm.javax.media.mscontrol.mixer.MediaMixerImpl;
import org.restcomm.javax.media.mscontrol.networkconnection.NetworkConnectionImpl;
import org.restcomm.javax.media.mscontrol.spi.DriverImpl;

public class MsControlFactoryImpl
implements MsControlFactory {
    private DriverImpl driver;
    private List<Integer> list = new ArrayList<Integer>();
    private List<MediaSession> sessions = new ArrayList<MediaSession>();
    private XMLParser parser = new XMLParser();
    private final Logger logger = Logger.getLogger(MsControlFactoryImpl.class);
    private ReentrantLock lock = new ReentrantLock();

    public MsControlFactoryImpl(DriverImpl driver) {
        this.driver = driver;
    }

    public DriverImpl getDriver() {
        return this.driver;
    }

    public int getUniqueHandler() {
        return this.driver.getNextTxID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaSession createMediaSession() {
        this.lock.lock();
        try {
            MediaSessionImpl session = new MediaSessionImpl(this);
            this.sessions.add(session);
            MediaSessionImpl mediaSessionImpl = session;
            return mediaSessionImpl;
        }
        catch (MsControlException e) {
            MediaSession mediaSession = null;
            return mediaSession;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(MediaSessionImpl session) {
        this.lock.lock();
        try {
            this.sessions.remove(session);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Parameters createParameters() {
        return new ParametersImpl();
    }

    public VideoLayout createVideoLayout(String mimeType, Reader xmlDef) throws MediaConfigException {
        return null;
    }

    public VideoLayout getPresetLayout(String type) throws MediaConfigException {
        return null;
    }

    public VideoLayout[] getPresetLayouts(int numberOfLiveRegions) throws MediaConfigException {
        return null;
    }

    public MediaConfig getMediaConfig(Configuration<?> cfg) throws MediaConfigException {
        if (cfg.equals((Object)NetworkConnection.BASIC)) {
            return NetworkConnectionImpl.BASE_CONFIG;
        }
        if (cfg.equals((Object)NetworkConnection.DTMF_CONVERSION)) {
            return null;
        }
        if (cfg.equals((Object)NetworkConnection.ECHO_CANCEL)) {
            return null;
        }
        if (cfg.equals((Object)MediaGroup.PLAYER)) {
            return MediaGroupImpl.PLAYER_CONFIG;
        }
        if (cfg.equals((Object)MediaGroup.SIGNALDETECTOR)) {
            return MediaGroupImpl.SIGNAL_DETECTOR_CONFIG;
        }
        if (cfg.equals((Object)MediaGroup.PLAYER_SIGNALDETECTOR)) {
            return MediaGroupImpl.PLAYER_SIGNAL_DETECTOR_CONFIG;
        }
        if (cfg.equals((Object)MediaGroupImpl.RECORDER_CONFIG)) {
            return MediaGroupImpl.RECORDER_CONFIG;
        }
        if (cfg.equals((Object)MediaGroupImpl.PLAYER_RECORDER_SIGNALDETECTOR)) {
            return MediaGroupImpl.PLAYER_RECORDER_SIGNAL_DETECTOR_CONFIG;
        }
        if (cfg.equals((Object)MediaMixer.AUDIO)) {
            return MediaMixerImpl.AUDIO_CONFIG;
        }
        throw new MediaConfigException("Unsupported Configuration " + cfg);
    }

    public MediaConfig getMediaConfig(Reader paramReader) throws MediaConfigException {
        return null;
    }

    public MediaObject getMediaObject(URI paramURI) {
        return null;
    }

    protected int getActiveSessions() {
        return this.sessions.size();
    }

    public Properties getProperties() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

