/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.fsm;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.restcomm.fsm.FSM;
import org.restcomm.fsm.StateEventHandler;
import org.restcomm.fsm.Transition;
import org.restcomm.fsm.UnknownTransitionException;

public class State
implements Runnable {
    private String name;
    private FSM fsm;
    private ArrayList<Transition> transitions = new ArrayList();
    protected long timeout;
    private long activated;
    private StateEventHandler enterEventHandler;
    private StateEventHandler exitEventHandler;

    protected State(FSM fsm, String name) {
        this.name = name;
        this.fsm = fsm;
        this.timeout = 0L;
    }

    public void setOnEnter(StateEventHandler handler) {
        this.enterEventHandler = handler;
    }

    public void setOnExit(StateEventHandler handler) {
        this.exitEventHandler = handler;
    }

    protected void enter() {
        this.activated = System.currentTimeMillis();
        if (this.enterEventHandler != null) {
            this.enterEventHandler.onEvent(this);
        }
        if (this == this.fsm.end) {
            this.fsm.timer.cancel(false);
        }
    }

    protected void leave() {
        this.activated = 0L;
        if (this.exitEventHandler != null) {
            this.exitEventHandler.onEvent(this);
        }
        if (this == this.fsm.start) {
            this.fsm.timer = this.fsm.scheduler.scheduleAtFixedRate(this.fsm, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    protected void tick(long now) {
        if (this.timeout > 0L && this.activated > 0L && now - this.activated > this.timeout) {
            try {
                this.fsm.signal("timeout");
            }
            catch (UnknownTransitionException unknownTransitionException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public FSM getFSM() {
        return this.fsm;
    }

    protected void add(Transition t) {
        this.transitions.add(t);
    }

    public State signal(String name) throws UnknownTransitionException {
        Transition t = this.find(name);
        if (t != null) {
            return t.process(this);
        }
        throw new UnknownTransitionException(name);
    }

    private Transition find(String name) {
        for (Transition t : this.transitions) {
            if (!t.getName().matches(name)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class LeaveAction
    implements Runnable {
        private State state;

        private LeaveAction(State state2) {
            this.state = state2;
        }

        @Override
        public void run() {
            State.this.exitEventHandler.onEvent(this.state);
        }
    }

    private class EnterAction
    implements Runnable {
        private State state;

        private EnterAction(State state2) {
            this.state = state2;
        }

        @Override
        public void run() {
            State.this.enterEventHandler.onEvent(this.state);
        }
    }
}

