/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol.spi;

import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.spi.Driver;
import javax.media.mscontrol.spi.DriverManager;
import javax.media.mscontrol.spi.PropertyInfo;
import org.apache.log4j.Logger;
import org.restcomm.javax.media.mscontrol.MsControlFactoryImpl;
import org.restcomm.media.client.mgcp.stack.JainMgcpStackImpl;

public class DriverImpl
implements Driver,
JainMgcpListener {
    public static final String DRIVER_NAME = "org.mobicents.Driver_1.0";
    private JainMgcpStack mgcpStack;
    private JainMgcpProvider mgcpProvider;
    private NotifiedEntity callAgent;
    private String localHost;
    private String remoteHost;
    private int localPort;
    private int remotePort;
    private ScheduledExecutorService scheduler;
    private MsControlFactoryImpl factory;
    private Logger logger = Logger.getLogger(DriverImpl.class);
    private int txID;
    private ConcurrentHashMap<Integer, JainMgcpListener> txListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<String, JainMgcpListener> requestListeners = new ConcurrentHashMap();

    public MsControlFactory getFactory(Properties config) throws MsControlException {
        boolean testMode;
        if (this.factory != null) {
            return this.factory;
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        if (config == null) {
            config = new Properties();
            config.setProperty("mgcp.bind.address", "127.0.0.1");
            config.setProperty("mgcp.server.address", "127.0.0.1");
            config.setProperty("mgcp.local.port", "2729");
            config.setProperty("mgcp.server.port", "2427");
        }
        this.localHost = config.getProperty("mgcp.bind.address");
        this.remoteHost = config.getProperty("mgcp.server.address");
        this.localPort = Integer.parseInt(config.getProperty("mgcp.local.port"));
        this.remotePort = Integer.parseInt(config.getProperty("mgcp.server.port"));
        InetAddress bindAddress = null;
        try {
            bindAddress = InetAddress.getByName(this.localHost);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        boolean bl = testMode = config.getProperty("driver.test.mode") != null && Boolean.parseBoolean(config.getProperty("driver.test.mode"));
        if (!testMode) {
            this.logger.info((Object)("Initializing MGCP on " + bindAddress + ":" + this.localPort));
            try {
                this.mgcpStack = new JainMgcpStackImpl(bindAddress, this.localPort);
                this.mgcpProvider = this.mgcpStack.createProvider();
                this.mgcpProvider.addJainMgcpListener((JainMgcpListener)this);
            }
            catch (Exception e) {
                throw new MsControlException(e.getMessage());
            }
        }
        this.callAgent = new NotifiedEntity("mscontrol", this.localHost, this.localPort);
        this.factory = new MsControlFactoryImpl(this);
        return this.factory;
    }

    public synchronized int getNextTxID() {
        return ++this.txID;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public NotifiedEntity getCallAgent() {
        return this.callAgent;
    }

    public String getRemoteDomainName() {
        return this.remoteHost + ":" + this.remotePort;
    }

    public void send(JainMgcpEvent evt) {
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{evt});
    }

    public void attach(RequestIdentifier reqID, JainMgcpListener listener) {
        this.requestListeners.put(reqID.toString().trim(), listener);
    }

    public void deattach(RequestIdentifier reqID) {
        this.requestListeners.remove(reqID.toString().trim());
    }

    public void attach(int txID, JainMgcpListener listener) {
        this.txListeners.put(txID, listener);
    }

    public void deattach(JainMgcpListener listener) {
        int identifier = -1;
        Set IDs = this.txListeners.keySet();
        for (Integer id : IDs) {
            if (this.txListeners.get(id) != listener) continue;
            identifier = id;
            break;
        }
        if (identifier != -1) {
            this.txListeners.remove(identifier);
        }
    }

    public PropertyInfo[] getFactoryPropertyInfo() {
        return null;
    }

    public String getName() {
        return DRIVER_NAME;
    }

    public void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        this.scheduler = null;
        if (this.mgcpProvider != null) {
            try {
                this.mgcpProvider.getJainMgcpStack().deleteProvider(this.mgcpProvider);
            }
            catch (DeleteProviderException e) {
                e.printStackTrace();
            }
            this.mgcpProvider = null;
            this.mgcpStack = null;
        }
        this.factory = null;
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent evt) {
        switch (evt.getObjectIdentifier()) {
            case 104: {
                break;
            }
            case 108: {
                Notify event = (Notify)evt;
                if (this.requestListeners.containsKey(event.getRequestIdentifier().toString().trim())) {
                    this.requestListeners.get(event.getRequestIdentifier().toString().trim()).processMgcpCommandEvent(evt);
                }
                NotifyResponse response = new NotifyResponse((Object)this, ReturnCode.Transaction_Executed_Normally);
                response.setTransactionHandle(evt.getTransactionHandle());
                this.send((JainMgcpEvent)response);
                break;
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
        JainMgcpListener handler = null;
        handler = event.getReturnCode() != ReturnCode.Transaction_Being_Executed ? this.txListeners.remove(event.getTransactionHandle()) : this.txListeners.get(event.getTransactionHandle());
        if (handler == null) {
            return;
        }
        handler.processMgcpResponseEvent(event);
    }

    public void info(String s) {
        this.logger.info((Object)s);
    }

    public void debug(String s) {
        this.logger.debug((Object)s);
    }

    public void warn(String s) {
        this.logger.warn((Object)s);
    }

    static {
        DriverManager.registerDriver((Driver)new DriverImpl());
    }
}

