/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mediagroup.SpeechDetectorConstants;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.Resource;
import javax.media.mscontrol.resource.Trigger;
import org.restcomm.fsm.FSM;
import org.restcomm.fsm.State;
import org.restcomm.fsm.StateEventHandler;
import org.restcomm.fsm.TransitionHandler;
import org.restcomm.fsm.UnknownTransitionException;
import org.restcomm.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.restcomm.javax.media.mscontrol.mediagroup.RecorderEventImpl;
import org.restcomm.javax.media.mscontrol.mediagroup.signals.Options;
import org.restcomm.javax.media.mscontrol.spi.DriverImpl;
import org.restcomm.jsr309.mgcp.PackageAU;

public class RecorderImpl
implements Recorder,
JainMgcpListener {
    public static final String STATE_IDLE = "IDLE";
    public static final String STATE_ACTIVATING = "ACTIVATING";
    public static final String STATE_ACTIVE = "ACTIVE";
    public static final String STATE_PAUSED = "PAUSED";
    public static final String STATE_STOPPING = "STOPPING";
    public static final String SIGNAL_START = "start";
    public static final String SIGNAL_START_PAUSED = "start_paused";
    public static final String SIGNAL_STOP = "stop";
    public static final String SIGNAL_PAUSE = "pause";
    public static final String SIGNAL_RESUME = "resume";
    public static final String SIGNAL_SUCCESS = "success";
    public static final String SIGNAL_FAILURE = "failure";
    public static final String SIGNAL_COMPLETE = "complete";
    protected MediaGroupImpl parent = null;
    private FSM fsm;
    private String params;
    protected CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> listeners = new CopyOnWriteArrayList();
    private RecorderEventImpl recorderEvent;
    private boolean rtcTriggered = false;
    private ArrayList<Trigger> triggers = new ArrayList();
    private MgcpSender mgcpSender;

    public RecorderImpl(MediaGroupImpl mediaGroup) {
        this.parent = mediaGroup;
        this.mgcpSender = new MgcpSender();
        this.initFSM();
    }

    private void initFSM() {
        this.fsm = new FSM(this.parent.getMediaSession().getDriver().getScheduler());
        this.fsm.createState(STATE_IDLE);
        this.fsm.createState(STATE_ACTIVATING);
        this.fsm.createState(STATE_ACTIVE);
        this.fsm.createState(STATE_PAUSED);
        this.fsm.createState(STATE_STOPPING).setOnEnter(new StopRequest());
        this.fsm.setStart(STATE_IDLE);
        this.fsm.setEnd(STATE_IDLE);
        this.fsm.createTransition(SIGNAL_START, STATE_IDLE, STATE_ACTIVATING).setHandler(new RecordRequest());
        this.fsm.createTransition(SIGNAL_START_PAUSED, STATE_IDLE, STATE_PAUSED);
        this.fsm.createTransition(SIGNAL_SUCCESS, STATE_ACTIVATING, STATE_ACTIVE);
        this.fsm.createTransition(SIGNAL_FAILURE, STATE_ACTIVATING, STATE_IDLE).setHandler(new CompleteNotify());
        this.fsm.createTransition(SIGNAL_STOP, STATE_ACTIVATING, STATE_IDLE);
        this.fsm.createTransition(SIGNAL_STOP, STATE_ACTIVE, STATE_STOPPING);
        this.fsm.createTransition(SIGNAL_PAUSE, STATE_ACTIVE, STATE_PAUSED);
        this.fsm.createTransition(SIGNAL_COMPLETE, STATE_ACTIVE, STATE_IDLE).setHandler(new CompleteNotify());
        this.fsm.createTransition(SIGNAL_FAILURE, STATE_ACTIVE, STATE_IDLE);
        this.fsm.createTransition(SIGNAL_STOP, STATE_PAUSED, STATE_IDLE);
        this.fsm.createTransition(SIGNAL_RESUME, STATE_PAUSED, STATE_ACTIVE);
        this.fsm.createTransition(SIGNAL_SUCCESS, STATE_STOPPING, STATE_IDLE).setHandler(new StoppedNotify());
    }

    public void record(URI streamID, RTC[] rtc, Parameters optargs) throws MsControlException {
        if (rtc != null) {
            this.verifyRTC(rtc);
        }
        if (this.parent.getJoinees(Joinable.Direction.RECV).length == 0) {
            throw new JoinException(this.parent.getURI() + " Container is not joined to any other container");
        }
        String[] patterns = this.getPatterns(rtc, optargs);
        Options options = new Options();
        options.setRecordID(streamID.toString());
        if (patterns != null) {
            options.setDigitPattern(patterns);
        }
        if (optargs != null && optargs.containsKey((Object)Recorder.MAX_DURATION)) {
            options.setRecordDuraion(((Integer)optargs.get((Object)Recorder.MAX_DURATION)).intValue());
        }
        if (optargs != null && optargs.containsKey((Object)Recorder.APPEND)) {
            options.setOverride((Boolean)optargs.get((Object)Recorder.APPEND) == false);
        }
        if (optargs != null && optargs.containsKey((Object)Recorder.SILENCE_TERMINATION_ON)) {
            options.setSilenceTermination((Boolean)optargs.get((Object)Recorder.SILENCE_TERMINATION_ON));
        }
        if (optargs != null && optargs.containsKey((Object)SpeechDetectorConstants.FINAL_TIMEOUT)) {
            options.setSilenceTermination(false);
            if (optargs.get((Object)SpeechDetectorConstants.FINAL_TIMEOUT) != Resource.FOR_EVER) {
                options.setPostSpeechTimer(((Integer)optargs.get((Object)SpeechDetectorConstants.FINAL_TIMEOUT)).intValue());
            }
        }
        Boolean hasPrompt = false;
        if (optargs != null && optargs.containsKey((Object)Recorder.PROMPT)) {
            hasPrompt = true;
            options.setPrompt(((URI)optargs.get((Object)Recorder.PROMPT)).toString());
        }
        options.setNonInterruptiblePlay(true);
        if (rtc != null) {
            System.out.println("-------------------------------------");
            System.out.println("triggers=" + rtc.length);
            for (int i = 0; i < rtc.length; ++i) {
                System.out.println("Trigger = " + rtc[i].getTrigger());
                if (rtc[i] == MediaGroup.SIGDET_STOPPLAY) {
                    options.setNonInterruptiblePlay(false);
                    continue;
                }
                if (rtc[i].getTrigger() == SignalDetector.DETECTION_OF_ONE_SIGNAL) {
                    options.setDigitsNumber(1);
                    if (rtc[i].getAction() != Recorder.STOP || !hasPrompt.booleanValue()) continue;
                    options.setDigitsNumber(2);
                    continue;
                }
                if (rtc[i].getTrigger() != Player.PLAY_START || rtc[i].getAction() != SignalDetector.FLUSH_BUFFER) continue;
                options.setClearDigits(true);
            }
        }
        this.params = options.toString();
        try {
            this.fsm.signal(SIGNAL_START);
        }
        catch (UnknownTransitionException e) {
            throw new MsControlException(e.getMessage());
        }
    }

    private void verifyRTC(RTC[] rtc) throws UnsupportedException {
        for (RTC r : rtc) {
            if (r.getTrigger() != Player.PLAY_START || r.getAction() != Player.STOP) continue;
            throw new UnsupportedException("Invalid RTC");
        }
    }

    private String[] getPatterns(RTC[] rtc, Parameters options) {
        if (rtc == null || options == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (RTC r : rtc) {
            for (int i = 0; i < SignalDetector.PATTERN_MATCH.length; ++i) {
                if (r.getTrigger() != SignalDetector.PATTERN_MATCH[i] || !options.containsKey((Object)SignalDetector.PATTERN[i])) continue;
                String s = (String)options.get((Object)SignalDetector.PATTERN[i]);
                String pattern = "";
                for (int k = 0; k < s.length() - 1; ++k) {
                    pattern = pattern + s.charAt(k) + "|";
                }
                pattern = pattern + s.charAt(s.length() - 1);
                list.add(pattern);
                this.triggers.add(SignalDetector.PATTERN_MATCH[i]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        String[] patterns = new String[list.size()];
        list.toArray(patterns);
        this.rtcTriggered = true;
        return patterns;
    }

    public MediaGroup getContainer() {
        return this.parent;
    }

    public void stop() {
        try {
            this.fsm.signal(SIGNAL_STOP);
        }
        catch (UnknownTransitionException unknownTransitionException) {
            // empty catch block
        }
    }

    public void addListener(MediaEventListener<RecorderEvent> listener) {
        this.listeners.add(listener);
    }

    public MediaSession getMediaSession() {
        return this.parent.getMediaSession();
    }

    public void removeListener(MediaEventListener<RecorderEvent> listener) {
        this.listeners.remove(listener);
    }

    protected void update(RecorderEvent anEvent) {
        for (MediaEventListener<? extends MediaEvent<?>> mediaEventListener : this.listeners) {
            mediaEventListener.onEvent((MediaEvent)anEvent);
        }
    }

    private void requestRecording() {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        ArrayList<EventName> signalList = new ArrayList<EventName>();
        ArrayList<RequestedEvent> eventList = new ArrayList<RequestedEvent>();
        signalList.add(new EventName(PackageAU.Name, PackageAU.pr.withParm(this.params)));
        EventName[] signals = new EventName[signalList.size()];
        signalList.toArray(signals);
        eventList.add(new RequestedEvent(new EventName(PackageAU.Name, MgcpEvent.oc), actions));
        eventList.add(new RequestedEvent(new EventName(PackageAU.Name, MgcpEvent.of), actions));
        RequestedEvent[] events = new RequestedEvent[eventList.size()];
        eventList.toArray(events);
        req.setRequestedEvents(events);
        req.setSignalRequests(signals);
        req.setTransactionHandle(txID);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this);
        driver.attach(reqID, (JainMgcpListener)this);
        if (this.parent.isStopping()) {
            this.mgcpSender.init(driver, req);
        } else {
            driver.send((JainMgcpEvent)req);
        }
    }

    private void stopRecording() {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        req.setTransactionHandle(txID);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this);
        driver.attach(reqID, (JainMgcpListener)this);
        driver.send((JainMgcpEvent)req);
    }

    private void signal(String signal) {
        try {
            this.fsm.signal(signal);
        }
        catch (UnknownTransitionException unknownTransitionException) {
            // empty catch block
        }
    }

    private void fireEvent(RecorderEventImpl evt) {
        new Thread(new EventSender(evt)).start();
    }

    private void fireEvent(EventName eventName) {
        switch (eventName.getEventIdentifier().intValue()) {
            case 62: {
                Options options = new Options(eventName.getEventIdentifier().getParms());
                switch (options.getReturnCode()) {
                    case 100: {
                        this.recorderEvent = options.getPatternIndex() >= 0 ? new RecorderEventImpl(this, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.RTC_TRIGGERED, this.triggers.get(options.getPatternIndex()), 0) : (options.getDigitsCollected() != null ? new RecorderEventImpl(this, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.RTC_TRIGGERED, SignalDetector.DETECTION_OF_ONE_SIGNAL, 0) : new RecorderEventImpl(this, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.NO_QUALIFIER, null, 0));
                        this.signal(SIGNAL_COMPLETE);
                        break;
                    }
                    case 328: {
                        this.recorderEvent = new RecorderEventImpl(this, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.DURATION_EXCEEDED, null, 0);
                        this.signal(SIGNAL_COMPLETE);
                        break;
                    }
                    case 327: {
                        this.recorderEvent = new RecorderEventImpl(this, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.SILENCE, null, 0);
                        this.signal(SIGNAL_COMPLETE);
                    }
                }
                break;
            }
            case 63: {
                this.recorderEvent = new RecorderEventImpl(this, RecorderEvent.RECORD_COMPLETED, true, MediaErr.NOT_FOUND, "Not found");
                this.signal(SIGNAL_FAILURE);
            }
        }
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        switch (event.getObjectIdentifier()) {
            case 108: {
                EventName[] events;
                Notify notify = (Notify)event;
                for (EventName evt : events = notify.getObservedEvents()) {
                    this.fireEvent(evt);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
        switch (event.getReturnCode().getValue()) {
            case 100: {
                break;
            }
            case 200: {
                try {
                    this.fsm.signal(SIGNAL_SUCCESS);
                }
                catch (UnknownTransitionException e) {}
                break;
            }
            default: {
                try {
                    this.fsm.signal(SIGNAL_FAILURE);
                    break;
                }
                catch (UnknownTransitionException unknownTransitionException) {
                    // empty catch block
                }
            }
        }
    }

    private void delay(long amount) {
        try {
            Thread.sleep(amount);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopCompleted() {
        if (this.mgcpSender.waiting.booleanValue()) {
            this.mgcpSender.run();
        }
    }

    private class MgcpSender {
        private DriverImpl driver;
        private NotificationRequest req;
        private Boolean waiting = false;

        public void init(DriverImpl driver, NotificationRequest req) {
            this.driver = driver;
            this.req = req;
            this.waiting = true;
        }

        public void run() {
            this.driver.send((JainMgcpEvent)this.req);
            this.waiting = false;
        }
    }

    private class EventSender
    implements Runnable {
        protected RecorderEvent event;

        public EventSender(RecorderEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            for (MediaEventListener<? extends MediaEvent<?>> mediaEventListener : RecorderImpl.this.listeners) {
                mediaEventListener.onEvent((MediaEvent)this.event);
            }
        }
    }

    private class StoppedNotify
    implements TransitionHandler {
        private StoppedNotify() {
        }

        @Override
        public void process(State state) {
            RecorderImpl.this.fireEvent(new RecorderEventImpl(null, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.NO_QUALIFIER, null, 0));
        }
    }

    private class CompleteNotify
    implements TransitionHandler {
        private CompleteNotify() {
        }

        @Override
        public void process(State state) {
            RecorderImpl.this.fireEvent(RecorderImpl.this.recorderEvent);
        }
    }

    private class StopRequest
    implements StateEventHandler {
        private StopRequest() {
        }

        @Override
        public void onEvent(State state) {
            RecorderImpl.this.stopRecording();
        }
    }

    private class RecordRequest
    implements TransitionHandler {
        private RecordRequest() {
        }

        @Override
        public void process(State state) {
            RecorderImpl.this.requestRecording();
        }
    }
}

