/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.RTC;
import org.restcomm.fsm.FSM;
import org.restcomm.fsm.Logger;
import org.restcomm.fsm.State;
import org.restcomm.fsm.StateEventHandler;
import org.restcomm.fsm.TransitionHandler;
import org.restcomm.fsm.UnknownTransitionException;
import org.restcomm.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.restcomm.javax.media.mscontrol.mediagroup.PlayerEventImpl;
import org.restcomm.javax.media.mscontrol.spi.DriverImpl;
import org.restcomm.jsr309.mgcp.PackageAU;

public class PlayerImpl
implements Player,
JainMgcpListener,
Logger {
    public static final String STATE_NULL = "NULL";
    public static final String STATE_IDLE = "IDLE";
    public static final String STATE_ACTIVE = "ACTIVE";
    public static final String STATE_ACTIVATING = "ACTIVATING";
    public static final String STATE_PAUSED = "PAUSED";
    public static final String STATE_INVALID = "INVALID";
    public static final String SIGNAL_CREATE = "CREATE";
    public static final String SIGNAL_PLAY = "PLAY";
    public static final String SIGNAL_STARTED = "STARTED";
    public static final String SIGNAL_FAILED = "FAILED";
    public static final String SIGNAL_START_PAUSED = "START_PAUSED";
    public static final String SIGNAL_STOP = "STOP";
    public static final String SIGNAL_PAUSE = "PAUSE";
    public static final String SIGNAL_RESUME = "RESUME";
    public static final String SIGNAL_PLAY_COMPLETED = "PLAY_COMPLETED";
    public static final String SIGNAL_RELEASE = "RELEASE";
    protected MediaGroupImpl parent = null;
    private FSM fsm;
    protected CopyOnWriteArrayList<MediaEventListener<PlayerEvent>> listeners = new CopyOnWriteArrayList();
    protected String uri;
    private String params;
    private String returnCode;
    private Qualifier qualifier;
    private ReentrantLock lock = new ReentrantLock();
    private Condition started = this.lock.newCondition();
    private long startTime;
    private long timeError = 0L;
    private long stopTime;
    private long reqDuration;
    private ConcurrentLinkedQueue<PlayTask> playList = new ConcurrentLinkedQueue();
    private MgcpSender mgcpSender;

    protected PlayerImpl(MediaGroupImpl parent) throws MsControlException {
        this.parent = parent;
        this.mgcpSender = new MgcpSender();
        this.initFSM();
    }

    private void initFSM() {
        this.fsm = new FSM(this.parent.getMediaSession().getDriver().getScheduler());
        this.fsm.setLogger(this);
        this.fsm.createState(STATE_NULL);
        this.fsm.createState(STATE_IDLE);
        this.fsm.createState(STATE_ACTIVATING);
        this.fsm.createState(STATE_ACTIVE).setOnEnter(new OnStart());
        this.fsm.createState(STATE_PAUSED);
        this.fsm.createState(STATE_INVALID);
        this.fsm.setStart(STATE_NULL);
        this.fsm.setEnd(STATE_INVALID);
        this.fsm.createTransition(SIGNAL_CREATE, STATE_NULL, STATE_IDLE);
        this.fsm.createTransition(SIGNAL_RELEASE, STATE_NULL, STATE_INVALID);
        this.fsm.createTransition(SIGNAL_PLAY, STATE_IDLE, STATE_ACTIVATING).setHandler(new PlayRequest());
        this.fsm.createTransition(SIGNAL_START_PAUSED, STATE_IDLE, STATE_PAUSED);
        this.fsm.createTransition(SIGNAL_RELEASE, STATE_IDLE, STATE_INVALID);
        this.fsm.createTransition(SIGNAL_STARTED, STATE_ACTIVATING, STATE_ACTIVE);
        this.fsm.createTransition(SIGNAL_FAILED, STATE_ACTIVATING, STATE_IDLE);
        this.fsm.createTransition(SIGNAL_STOP, STATE_ACTIVATING, STATE_IDLE);
        this.fsm.createTransition("FAILURE", STATE_ACTIVE, STATE_IDLE).setHandler(new PlayFailure(this));
        this.fsm.createTransition(SIGNAL_RELEASE, STATE_ACTIVATING, STATE_INVALID).setHandler(new StopRequest(this));
        this.fsm.createTransition(SIGNAL_PLAY_COMPLETED, STATE_ACTIVE, STATE_IDLE).setHandler(new PlayCompleted(this));
        this.fsm.createTransition(SIGNAL_STOP, STATE_ACTIVE, STATE_IDLE).setHandler(new StopRequest(this));
        this.fsm.createTransition(SIGNAL_RELEASE, STATE_ACTIVE, STATE_INVALID).setHandler(new StopRequest(this));
        this.fsm.createTransition(SIGNAL_STOP, STATE_PAUSED, STATE_IDLE);
        this.fsm.createTransition(SIGNAL_RESUME, STATE_PAUSED, STATE_ACTIVE);
        this.fsm.createTransition(SIGNAL_RELEASE, STATE_INVALID, STATE_INVALID);
        try {
            this.fsm.signal(SIGNAL_CREATE);
        }
        catch (UnknownTransitionException unknownTransitionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(URI[] uris, RTC[] rtc, Parameters params) throws MsControlException {
        if (rtc != null) {
            this.verifyRTC(rtc);
        }
        this.checkURI(uris);
        PlayTask task = new PlayTask(uris, rtc, params);
        if (this.fsm.getState().getName().equals(STATE_IDLE)) {
            this.playList.offer(task);
        } else {
            if (params == null) {
                throw new MsControlException("Busy now: state=" + this.fsm.getState());
            }
            Value behaviour = (Value)params.get((Object)Player.BEHAVIOUR_IF_BUSY);
            this.playList.offer(task);
            if (Player.FAIL_IF_BUSY.equals(behaviour)) {
                throw new MsControlException("Busy now");
            }
            if (Player.STOP_IF_BUSY.equals(behaviour)) {
                try {
                    this.fsm.signal(SIGNAL_STOP);
                }
                catch (UnknownTransitionException e) {
                    // empty catch block
                }
            }
        }
        new Thread(new Starter()).start();
        this.lock.lock();
        try {
            try {
                this.started.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void play(URI uri, RTC[] rtc, Parameters params) throws MsControlException {
        this.play(new URI[]{uri}, rtc, params);
    }

    public MediaGroup getContainer() {
        return this.parent;
    }

    public void addListener(MediaEventListener<PlayerEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MediaEventListener<PlayerEvent> listener) {
        this.listeners.remove(listener);
    }

    public MediaSession getMediaSession() {
        return this.parent.getMediaSession();
    }

    protected void update(PlayerEvent anEvent) {
    }

    private void checkURI(URI[] uris) throws MsControlException {
        if (uris == null) {
            throw new MsControlException("URI[] cannot be null");
        }
        for (URI uri : uris) {
            if (uri == null) {
                throw new MsControlException("URI cannot be null");
            }
            if (!uri.getScheme().equalsIgnoreCase("data")) continue;
        }
    }

    public void stop(boolean stopAll) {
        try {
            this.fsm.signal(SIGNAL_STOP);
        }
        catch (UnknownTransitionException unknownTransitionException) {
            // empty catch block
        }
    }

    private void verifyRTC(RTC[] rtc) throws UnsupportedException {
        for (RTC r : rtc) {
            if (r.getTrigger() != Player.PLAY_START || r.getAction() != Player.STOP) continue;
            throw new UnsupportedException("Invalid RTC");
        }
    }

    protected void fireEvent(PlayerEvent event) {
        new Thread(new EventSender(event)).start();
    }

    private String createParams(URI[] uris, Parameters params) {
        StringBuilder buff = new StringBuilder();
        if (uris.length == 1) {
            buff.append("an=").append(uris[0].toString());
        } else {
            buff.append("an=").append(uris[0].toString());
            for (int i = 1; i < uris.length; ++i) {
                buff.append(";");
                buff.append(uris[i].toString());
            }
        }
        this.qualifier = PlayerEvent.END_OF_PLAY_LIST;
        if (params != null && params.containsKey((Object)Player.MAX_DURATION)) {
            long du = ((Integer)params.get((Object)Player.MAX_DURATION)).intValue();
            buff.append(" ");
            buff.append("du=").append(du);
            if (du > 0L) {
                this.qualifier = PlayerEvent.DURATION_EXCEEDED;
            }
            this.reqDuration = du;
        }
        if (params != null && params.containsKey((Object)Player.START_OFFSET)) {
            buff.append(" ");
            buff.append("of=").append(params.get((Object)Player.START_OFFSET));
        }
        if (params != null && params.containsKey((Object)Player.REPEAT_COUNT)) {
            int it = 0;
            if (params.get((Object)Player.REPEAT_COUNT) instanceof Integer) {
                try {
                    it = (Integer)params.get((Object)Player.REPEAT_COUNT);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (it < 0) {
                it = 0;
            }
            buff.append(" ");
            buff.append("it=").append(it);
        }
        if (params != null && params.containsKey((Object)Player.INTERVAL)) {
            buff.append(" ");
            buff.append("iv=").append(params.get((Object)Player.INTERVAL));
        }
        return buff.toString();
    }

    private void requestAnnouncement() {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
        ArrayList<EventName> signalList = new ArrayList<EventName>();
        ArrayList<RequestedEvent> eventList = new ArrayList<RequestedEvent>();
        signalList.add(new EventName(PackageAU.Name, PackageAU.pa.withParm(this.params)));
        eventList.add(new RequestedEvent(new EventName(PackageAU.Name, MgcpEvent.oc), actions));
        eventList.add(new RequestedEvent(new EventName(PackageAU.Name, MgcpEvent.of), actions));
        EventName[] signals = new EventName[signalList.size()];
        signalList.toArray(signals);
        RequestedEvent[] events = new RequestedEvent[eventList.size()];
        eventList.toArray(events);
        req.setRequestedEvents(events);
        req.setSignalRequests(signals);
        req.setTransactionHandle(txID);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this);
        driver.attach(reqID, (JainMgcpListener)this);
        if (this.parent.isStopping()) {
            this.mgcpSender.init(driver, req);
        } else {
            driver.send((JainMgcpEvent)req);
        }
    }

    private void requestStop() {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        req.setTransactionHandle(txID);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this);
        driver.attach(reqID, (JainMgcpListener)this);
        driver.send((JainMgcpEvent)req);
    }

    private void fireEvent(EventName eventName) {
        this.returnCode = eventName.getEventIdentifier().getParms();
        switch (eventName.getEventIdentifier().intValue()) {
            case 62: {
                try {
                    this.fsm.signal(SIGNAL_PLAY_COMPLETED);
                }
                catch (UnknownTransitionException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 63: {
                try {
                    this.fsm.signal("FAILURE");
                    break;
                }
                catch (UnknownTransitionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void stopCompleted() {
        if (this.mgcpSender.waiting.booleanValue()) {
            this.mgcpSender.run();
        }
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        switch (event.getObjectIdentifier()) {
            case 108: {
                EventName[] events;
                Notify notify = (Notify)event;
                for (EventName evt : events = notify.getObservedEvents()) {
                    this.fireEvent(evt);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
        switch (event.getReturnCode().getValue()) {
            case 100: {
                break;
            }
            case 200: {
                try {
                    this.fsm.signal(SIGNAL_STARTED);
                }
                catch (UnknownTransitionException e) {}
                break;
            }
            default: {
                try {
                    this.fsm.signal(SIGNAL_FAILED);
                    break;
                }
                catch (UnknownTransitionException unknownTransitionException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void info(String s) {
        this.parent.info(s);
    }

    @Override
    public void debug(String s) {
        this.parent.debug(s);
    }

    @Override
    public void warn(String s) {
        this.parent.warn(s);
    }

    private class MgcpSender {
        private DriverImpl driver;
        private NotificationRequest req;
        private Boolean waiting = false;

        public void init(DriverImpl driver, NotificationRequest req) {
            this.driver = driver;
            this.req = req;
            this.waiting = true;
        }

        public void run() {
            this.driver.send((JainMgcpEvent)this.req);
            this.waiting = false;
        }
    }

    private class EventSender
    implements Runnable {
        private PlayerEvent evt;

        public EventSender(PlayerEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (MediaEventListener<PlayerEvent> l : PlayerImpl.this.listeners) {
                l.onEvent((MediaEvent)this.evt);
            }
        }
    }

    private class Starter
    implements Runnable {
        private Starter() {
        }

        @Override
        public void run() {
            PlayTask task = (PlayTask)PlayerImpl.this.playList.poll();
            PlayerImpl.this.params = PlayerImpl.this.createParams(task.uris, task.params);
            try {
                PlayerImpl.this.fsm.signal(PlayerImpl.SIGNAL_PLAY);
            }
            catch (UnknownTransitionException unknownTransitionException) {
                // empty catch block
            }
        }
    }

    private class PlayTask {
        private URI[] uris;
        private RTC[] rtc;
        private Parameters params;

        protected PlayTask(URI[] uris, RTC[] rtc, Parameters params) {
            this.uris = uris;
            this.rtc = rtc;
            this.params = params;
        }
    }

    private class OnStart
    implements StateEventHandler {
        private OnStart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(State state) {
            PlayerImpl.this.startTime = System.currentTimeMillis() + PlayerImpl.this.timeError;
            PlayerImpl.this.lock.lock();
            try {
                PlayerImpl.this.started.signal();
            }
            finally {
                PlayerImpl.this.lock.unlock();
            }
        }
    }

    private class StopRequest
    implements TransitionHandler {
        private PlayerImpl player;

        protected StopRequest(PlayerImpl player) {
            this.player = player;
        }

        @Override
        public void process(State state) {
            PlayerImpl.this.requestStop();
            PlayerEventImpl evt = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, true, PlayerEvent.STOPPED, null);
            evt.setOffset((int)(PlayerImpl.this.stopTime - PlayerImpl.this.startTime));
            PlayerImpl.this.fireEvent(evt);
        }
    }

    private class PlayFailure
    implements TransitionHandler {
        private PlayerImpl player;

        protected PlayFailure(PlayerImpl player) {
            this.player = player;
        }

        @Override
        public void process(State state) {
            MediaErr error = null;
            if (PlayerImpl.this.returnCode.equals("rc=301")) {
                error = MediaErr.BAD_ARG;
            } else if (PlayerImpl.this.returnCode.equals("rc=312")) {
                error = MediaErr.NOT_FOUND;
            }
            PlayerImpl.this.stopTime = System.currentTimeMillis();
            PlayerEventImpl evt = new PlayerEventImpl(this.player, PlayerEvent.PLAY_COMPLETED, false, PlayerEvent.NO_QUALIFIER, null, error, "");
            evt.setOffset((int)(PlayerImpl.this.stopTime - PlayerImpl.this.startTime));
            PlayerImpl.this.fireEvent(evt);
            if (!PlayerImpl.this.playList.isEmpty()) {
                new Thread(new Starter()).start();
            }
        }
    }

    private class PlayCompleted
    implements TransitionHandler {
        private PlayerImpl player;

        protected PlayCompleted(PlayerImpl player) {
            this.player = player;
        }

        @Override
        public void process(State state) {
            PlayerImpl.this.stopTime = System.currentTimeMillis();
            if (Math.abs(PlayerImpl.this.stopTime - PlayerImpl.this.startTime - PlayerImpl.this.reqDuration) > 1000L) {
                PlayerImpl.this.qualifier = PlayerEvent.END_OF_PLAY_LIST;
            }
            PlayerEventImpl evt = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, true, PlayerImpl.this.qualifier, null);
            evt.setOffset((int)(PlayerImpl.this.stopTime - PlayerImpl.this.startTime));
            PlayerImpl.this.fireEvent(evt);
            if (!PlayerImpl.this.playList.isEmpty()) {
                new Thread(new Starter()).start();
            }
        }
    }

    private class PlayRequest
    implements TransitionHandler {
        private PlayRequest() {
        }

        @Override
        public void process(State state) {
            PlayerImpl.this.requestAnnouncement();
        }
    }
}

