/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol.mediagroup;

import java.util.HashSet;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Trigger;
import org.restcomm.javax.media.mscontrol.MediaConfigImpl;
import org.restcomm.javax.media.mscontrol.MediaObjectImpl;
import org.restcomm.javax.media.mscontrol.ParametersImpl;
import org.restcomm.javax.media.mscontrol.SupportedFeaturesImpl;

public class SignalDetectorConfig
implements Configuration {
    private MediaConfigImpl config;
    private Parameters params = new ParametersImpl();

    protected SignalDetectorConfig() {
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        parameters.add(SignalDetector.INITIAL_TIMEOUT);
        parameters.add(SignalDetector.MAX_DURATION);
        parameters.add(SignalDetector.INTER_SIG_TIMEOUT);
        for (Parameter p : SignalDetector.PATTERN) {
            parameters.add(p);
        }
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        eventTypes.add(SignalDetectorEvent.OVERFLOWED);
        eventTypes.add(SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED);
        eventTypes.add(SignalDetectorEvent.SIGNAL_DETECTED);
        for (EventType e : SignalDetectorEvent.PATTERN_MATCHED) {
            eventTypes.add(e);
        }
        HashSet<Action> actions = new HashSet<Action>();
        HashSet<Qualifier> qualifiers = new HashSet<Qualifier>();
        qualifiers.add(SignalDetectorEvent.DURATION_EXCEEDED);
        qualifiers.add(SignalDetectorEvent.INITIAL_TIMEOUT_EXCEEDED);
        qualifiers.add(SignalDetectorEvent.INTER_SIG_TIMEOUT_EXCEEDED);
        qualifiers.add(SignalDetectorEvent.NUM_SIGNALS_DETECTED);
        for (Qualifier q : SignalDetectorEvent.PATTERN_MATCHING) {
            qualifiers.add(q);
        }
        qualifiers.add(SignalDetectorEvent.PROMPT_FAILURE);
        HashSet<Trigger> triggers = new HashSet<Trigger>();
        triggers.add(SignalDetector.DETECTION_OF_ONE_SIGNAL);
        triggers.add(SignalDetector.FLUSHING_OF_BUFFER);
        for (Trigger t : SignalDetector.PATTERN_MATCH) {
            triggers.add(t);
        }
        triggers.add(SignalDetector.RECEIVE_SIGNALS_COMPLETION);
        HashSet<Value> values = new HashSet<Value>();
        this.params.put((Object)MediaObjectImpl.ENDPOINT_NAME, (Object)"mobicents/ivr/$");
        SupportedFeaturesImpl features = new SupportedFeaturesImpl(parameters, actions, eventTypes, qualifiers, triggers, values);
        this.config = new MediaConfigImpl(features, this.params);
    }

    public MediaConfig getConfig() {
        return this.config;
    }
}

