/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.test;

import java.util.Properties;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.spi.DriverManager;
import org.restcomm.javax.media.mscontrol.spi.DriverImpl;

public class Tester {
    private DriverImpl driver;
    private MsControlFactory factory;

    public void init() throws MsControlException {
        Properties cfg = new Properties();
        cfg.put(cfg, cfg);
        this.driver = (DriverImpl)DriverManager.getDriver((String)"org.mobicents.Driver_1.0");
        this.factory = this.driver.getFactory(null);
    }

    public void run() throws MsControlException, InterruptedException {
        MediaSession session = this.factory.createMediaSession();
        final NetworkConnection c1 = session.createNetworkConnection(NetworkConnection.BASIC);
        final NetworkConnection c2 = session.createNetworkConnection(NetworkConnection.BASIC);
        MediaGroup g1 = session.createMediaGroup(MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR);
        MediaGroup g2 = session.createMediaGroup(MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR);
        c1.getSdpPortManager().addListener((MediaEventListener)new MediaEventListener<SdpPortManagerEvent>(){

            public void onEvent(SdpPortManagerEvent event) {
                if (event.getEventType() == SdpPortManagerEvent.OFFER_GENERATED) {
                    try {
                        c2.getSdpPortManager().processSdpOffer(event.getMediaServerSdp());
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("BAD!BAD!BAD!");
                }
            }
        });
        c2.getSdpPortManager().addListener((MediaEventListener)new MediaEventListener<SdpPortManagerEvent>(){

            public void onEvent(SdpPortManagerEvent event) {
                if (event.getEventType() == SdpPortManagerEvent.ANSWER_PROCESSED) {
                    try {
                        c1.getSdpPortManager().processSdpAnswer(event.getMediaServerSdp());
                    }
                    catch (MsControlException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("BAD!BAD!BAD!");
                }
            }
        });
        c1.join(Joinable.Direction.DUPLEX, (Joinable)g1);
        c1.getSdpPortManager().generateSdpOffer();
        c2.join(Joinable.Direction.DUPLEX, (Joinable)g2);
        session.release();
    }

    public void shutdown() {
        this.driver.shutdown();
    }

    public static void main(String[] args) throws Exception {
        Tester tester = new Tester();
        tester.init();
        for (int i = 0; i < 200; ++i) {
            System.out.println("Starting test " + i);
            tester.run();
            System.out.println("Completed test " + i);
        }
        tester.shutdown();
    }
}

