/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.javax.media.mscontrol.networkconnection;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import org.restcomm.fsm.UnknownTransitionException;
import org.restcomm.javax.media.mscontrol.networkconnection.NetworkConnectionImpl;

public class CreateConnectionResponseHandler
implements JainMgcpListener {
    private NetworkConnectionImpl connection;

    public CreateConnectionResponseHandler(NetworkConnectionImpl connection) {
        this.connection = connection;
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent evt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent evt) {
        CreateConnectionResponse resp = (CreateConnectionResponse)evt;
        switch (resp.getReturnCode().getValue()) {
            case 100: {
                return;
            }
            case 200: {
                this.connection.connectionID = resp.getConnectionIdentifier();
                this.connection.setConcreteName(resp.getSpecificEndpointIdentifier());
                try {
                    this.connection.sdpPortManager.setLocalDescriptor(resp.getLocalConnectionDescriptor().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.connection.fsm.signalAsync("failure");
                    return;
                }
                try {
                    if (this.connection.sdpPortManager.remoteSdp != null) {
                        this.connection.fsm.signal("opened");
                    } else {
                        this.connection.fsm.signal("created");
                    }
                }
                catch (UnknownTransitionException e) {
                    // empty catch block
                }
                return;
            }
            case 500: {
                this.connection.error = MediaErr.NOT_FOUND;
                break;
            }
            case 501: {
                this.connection.error = MediaErr.RESOURCE_UNAVAILABLE;
                break;
            }
            case 520: {
                this.connection.error = MediaErr.RESOURCE_UNAVAILABLE;
                break;
            }
            case 502: {
                this.connection.error = MediaErr.RESOURCE_UNAVAILABLE;
                break;
            }
            case 528: {
                this.connection.error = MediaErr.BAD_SERVER;
                break;
            }
            case 505: 
            case 527: {
                this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
                break;
            }
            case 400: {
                this.connection.error = MediaErr.NOT_SUPPORTED;
                break;
            }
            default: {
                this.connection.error = MediaErr.UNKNOWN_ERROR;
            }
        }
        this.connection.errorMsg = resp.getReturnCode().getComment();
        try {
            this.connection.fsm.signal("failure");
        }
        catch (UnknownTransitionException unknownTransitionException) {
            // empty catch block
        }
    }
}

