/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class ReasonCodeHandler {
    public static ReasonCode decode(byte[] value, int offset, int length) throws ParseException {
        int currIndex = offset;
        int numericValue = 0;
        int i = 0;
        while (i < length) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                if (i > 0 && value[currIndex] == 32) break;
                throw new ParseException("Invalid reason code:" + new String(value, offset, length), 0);
            }
            numericValue = numericValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        switch (numericValue) {
            case 900: {
                return ReasonCode.Endpoint_Malfunctioning;
            }
            case 901: {
                return ReasonCode.Endpoint_Out_Of_Service;
            }
            case 0: {
                return ReasonCode.Endpoint_State_Is_Nominal;
            }
            case 902: {
                return ReasonCode.Loss_Of_Lower_Layer_Connectivity;
            }
        }
        return null;
    }

    public static int encode(byte[] destination, int offset, ReasonCode reasonCode) {
        int totalLength = StringFunctions.encodeInt(destination, offset, reasonCode.getValue());
        destination[offset + totalLength] = 32;
        byte[] commentData = reasonCode.getComment().getBytes();
        System.arraycopy(commentData, 0, destination, offset + ++totalLength, commentData.length);
        return totalLength + commentData.length;
    }
}

