/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EmbeddedRequest;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.params.DigitMapHandler;
import org.restcomm.media.client.mgcp.parser.params.EventNameHandler;
import org.restcomm.media.client.mgcp.parser.params.RequestedEventHandler;

public class EmbeddedRequestHandler {
    private static Object decodeSingle(byte[] value, int offset, int length) throws ParseException {
        int contentStart;
        int startIndex;
        if (length <= 3) {
            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
        }
        for (startIndex = offset + 1; startIndex < offset + length && value[startIndex] == 32; ++startIndex) {
        }
        if (startIndex == offset + length) {
            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
        }
        if (value[startIndex] != 40) {
            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
        }
        if (value[offset + length - 1] != 41) {
            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
        }
        int contentEnd = offset + length - 2;
        for (contentStart = startIndex + 1; contentStart < contentEnd && value[contentStart] == 32; ++contentStart) {
        }
        while (contentEnd > contentStart && value[contentEnd] == 32) {
            --contentEnd;
        }
        if (contentStart == contentEnd) {
            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
        }
        byte currByte = value[offset];
        switch (currByte) {
            case 82: 
            case 114: {
                return RequestedEventHandler.decodeList(value, contentStart, contentEnd - contentStart + 1);
            }
            case 68: 
            case 100: {
                return DigitMapHandler.decode(value, contentStart, contentEnd - contentStart + 1);
            }
            case 83: 
            case 115: {
                return EventNameHandler.decodeList(value, contentStart, contentEnd - contentStart + 1);
            }
        }
        throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
    }

    public static EmbeddedRequest decode(byte[] value, int offset, int length) throws ParseException {
        Object currObject;
        RequestedEvent[] requestedEvents = null;
        EventName[] signalEvents = null;
        DigitMap digitMap = null;
        int currIndex = offset;
        int startIndex = offset;
        int i = 0;
        while (value[startIndex] == 32 && i < length) {
            ++startIndex;
            ++i;
            ++currIndex;
        }
        int depth = 0;
        while (i < length) {
            switch (value[currIndex]) {
                case 40: {
                    ++depth;
                    break;
                }
                case 44: {
                    if (depth != 0 || i >= length) break;
                    currObject = EmbeddedRequestHandler.decodeSingle(value, startIndex, currIndex - startIndex);
                    if (currObject instanceof DigitMap) {
                        if (digitMap != null) {
                            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                        }
                        digitMap = (DigitMap)currObject;
                    } else if (currObject instanceof RequestedEvent[]) {
                        if (requestedEvents != null) {
                            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                        }
                        requestedEvents = (RequestedEvent[])currObject;
                    } else if (currObject instanceof EventName[]) {
                        if (signalEvents != null) {
                            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                        }
                        signalEvents = (EventName[])currObject;
                    }
                    startIndex = currIndex + 1;
                    while (i < length - 1 && value[startIndex] == 32) {
                        ++startIndex;
                        ++i;
                        ++currIndex;
                    }
                    break;
                }
                case 41: {
                    if (--depth != 0 || i >= length) break;
                    while (i < length && value[currIndex] == 32) {
                        ++i;
                        ++currIndex;
                    }
                    if (i >= length - 1 || value[currIndex + 1] != 44) break;
                    currObject = EmbeddedRequestHandler.decodeSingle(value, startIndex, currIndex - startIndex + 1);
                    if (currObject instanceof DigitMap) {
                        if (digitMap != null) {
                            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                        }
                        digitMap = (DigitMap)currObject;
                    } else if (currObject instanceof RequestedEvent[]) {
                        if (requestedEvents != null) {
                            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                        }
                        requestedEvents = (RequestedEvent[])currObject;
                    } else if (currObject instanceof EventName[]) {
                        if (signalEvents != null) {
                            throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                        }
                        signalEvents = (EventName[])currObject;
                    }
                    startIndex = currIndex + 2;
                    ++i;
                    ++currIndex;
                    while (i < length - 1 && value[startIndex] == 32) {
                        ++startIndex;
                        ++i;
                        ++currIndex;
                    }
                    break;
                }
            }
            ++i;
            ++currIndex;
        }
        if (startIndex < offset + length) {
            currObject = EmbeddedRequestHandler.decodeSingle(value, startIndex, offset + length - startIndex);
            if (currObject instanceof DigitMap) {
                if (digitMap != null) {
                    throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                }
                digitMap = (DigitMap)currObject;
            } else if (currObject instanceof RequestedEvent[]) {
                if (requestedEvents != null) {
                    throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                }
                requestedEvents = (RequestedEvent[])currObject;
            } else if (currObject instanceof EventName[]) {
                if (signalEvents != null) {
                    throw new ParseException("Unknown value for Embedded Request: " + new String(value, offset, length), 0);
                }
                signalEvents = (EventName[])currObject;
            }
        }
        return new EmbeddedRequest(requestedEvents, signalEvents, digitMap);
    }

    public static int encode(byte[] destination, int offset, EmbeddedRequest embeddedRequest) {
        RequestedEvent[] requestedEventList = embeddedRequest.getEmbeddedRequestList();
        EventName[] eventNameList = embeddedRequest.getEmbeddedSignalRequest();
        DigitMap digitMap = embeddedRequest.getEmbeddedDigitMap();
        Boolean initial = true;
        int totalLength = 0;
        if (requestedEventList != null) {
            destination[offset + totalLength] = 82;
            destination[offset + totalLength + 1] = 40;
            totalLength += 2;
            totalLength += RequestedEventHandler.encodeList(destination, offset + totalLength, requestedEventList);
            destination[offset + totalLength] = 41;
            ++totalLength;
            initial = false;
        }
        if (eventNameList != null) {
            if (!initial.booleanValue()) {
                destination[offset + totalLength] = 44;
                ++totalLength;
            }
            destination[offset + totalLength] = 83;
            destination[offset + totalLength + 1] = 40;
            totalLength += 2;
            totalLength += EventNameHandler.encodeList(destination, offset + totalLength, eventNameList);
            destination[offset + totalLength] = 41;
            ++totalLength;
            initial = false;
        }
        if (digitMap != null) {
            if (!initial.booleanValue()) {
                destination[offset + totalLength] = 44;
                ++totalLength;
            }
            destination[offset + totalLength] = 68;
            destination[offset + totalLength + 1] = 40;
            totalLength += 2;
            totalLength += DigitMapHandler.encode(destination, offset + totalLength, digitMap);
            destination[offset + totalLength] = 41;
            ++totalLength;
        }
        return totalLength;
    }
}

