/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.pkg;

import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.jain.pkg.AUMgcpEvent;
import org.restcomm.media.client.mgcp.jain.pkg.AUPackage;
import org.restcomm.media.client.mgcp.jain.pkg.SLPackage;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class PackageNameHandler {
    static PackageName auPackage = AUPackage.AU;
    static PackageName slPackage = SLPackage.SL;
    static MgcpEvent rfc2897pa = AUMgcpEvent.aupa;

    public static PackageName decode(byte[] value, int offset, int length) throws ParseException {
        if (length == 1) {
            switch (value[offset]) {
                case 71: 
                case 103: {
                    return PackageName.GenericMedia;
                }
                case 68: 
                case 100: {
                    return PackageName.Dtmf;
                }
                case 77: 
                case 109: {
                    return PackageName.Mf;
                }
                case 84: 
                case 116: {
                    return PackageName.Trunk;
                }
                case 76: 
                case 108: {
                    return PackageName.Line;
                }
                case 72: 
                case 104: {
                    return PackageName.Handset;
                }
                case 82: 
                case 114: {
                    return PackageName.Rtp;
                }
                case 78: 
                case 110: {
                    return PackageName.Nas;
                }
                case 65: 
                case 97: {
                    return PackageName.Announcement;
                }
                case 42: {
                    return PackageName.AllPackages;
                }
            }
        } else if (!(length != 2 || value[offset] != 97 && value[offset] != 65 || value[offset + 1] != 117 && value[offset + 1] != 85)) {
            return AUPackage.AU;
        }
        return PackageName.factory((String)new String(value, offset, length));
    }

    public static int encode(byte[] destination, int offset, PackageName packageName) {
        switch (packageName.intValue()) {
            case 11: {
                destination[offset] = 42;
                return 1;
            }
            case 1: {
                destination[offset] = 71;
                return 1;
            }
            case 2: {
                destination[offset] = 68;
                return 1;
            }
            case 3: {
                destination[offset] = 77;
                return 1;
            }
            case 4: {
                destination[offset] = 84;
                return 1;
            }
            case 5: {
                destination[offset] = 76;
                return 1;
            }
            case 6: {
                destination[offset] = 72;
                return 1;
            }
            case 7: {
                destination[offset] = 82;
                return 1;
            }
            case 8: {
                destination[offset] = 78;
                return 1;
            }
            case 9: {
                destination[offset] = 65;
                return 1;
            }
            case 200: {
                destination[offset] = 65;
                destination[offset + 1] = 85;
                return 2;
            }
        }
        byte[] value = packageName.toString().getBytes();
        System.arraycopy(value, 0, destination, offset, value.length);
        return value.length;
    }

    public static int encodeList(byte[] destination, int offset, PackageName[] packageNames) {
        int i;
        if (packageNames.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < packageNames.length - 1; ++i) {
            totalLength += PackageNameHandler.encode(destination, offset + totalLength, packageNames[i]);
            destination[offset + totalLength] = 59;
            ++totalLength;
        }
        totalLength += PackageNameHandler.encode(destination, offset + totalLength, packageNames[i]);
        return totalLength;
    }

    public static PackageName[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)59);
        PackageName[] packageNames = new PackageName[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            packageNames[i] = PackageNameHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return packageNames;
    }
}

