/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.utils;

import org.apache.log4j.Logger;
import org.restcomm.media.client.mgcp.utils.PacketRepresentation;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;

public class PacketRepresentationFactory {
    private static final Logger logger = Logger.getLogger(PacketRepresentationFactory.class);
    private ConcurrentCyclicFIFO<PacketRepresentation> list = new ConcurrentCyclicFIFO();
    private int size = 0;
    private int dataArrSize = 0;
    private int count = 0;

    public PacketRepresentationFactory(int size, int dataArrSize) {
        this.size = size;
        this.dataArrSize = dataArrSize;
        for (int i = 0; i < size; ++i) {
            PacketRepresentation pr = new PacketRepresentation(dataArrSize, this);
            this.list.offer((Object)pr);
        }
    }

    public PacketRepresentation allocate() {
        PacketRepresentation pr = (PacketRepresentation)this.list.poll();
        if (pr != null) {
            pr.setLength(0);
            return pr;
        }
        pr = new PacketRepresentation(this.dataArrSize, this);
        ++this.count;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PRFactory underflow. Count = " + this.count));
        }
        logger.error((Object)("PRFactory underflow. Count = " + this.count));
        return pr;
    }

    public void deallocate(PacketRepresentation pr) {
        this.list.offer((Object)pr);
    }

    public int getSize() {
        return this.size;
    }

    public int getDataArrSize() {
        return this.dataArrSize;
    }

    public int getCount() {
        return this.count;
    }
}

