/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditEndpoint;
import jain.protocol.ip.mgcp.message.AuditEndpointResponse;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CapabilityValue;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.restcomm.media.client.mgcp.handlers.MgcpContentHandler;
import org.restcomm.media.client.mgcp.handlers.TransactionHandler;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;
import org.restcomm.media.client.mgcp.parser.params.BearerInformationHandler;
import org.restcomm.media.client.mgcp.parser.params.CapabilityHandler;
import org.restcomm.media.client.mgcp.parser.params.DigitMapHandler;
import org.restcomm.media.client.mgcp.parser.params.EndpointIdentifierHandler;
import org.restcomm.media.client.mgcp.parser.params.EventNameHandler;
import org.restcomm.media.client.mgcp.parser.params.InfoCodeHandler;
import org.restcomm.media.client.mgcp.parser.params.NotifiedEntityHandler;
import org.restcomm.media.client.mgcp.parser.params.ReasonCodeHandler;
import org.restcomm.media.client.mgcp.parser.params.RequestedEventHandler;
import org.restcomm.media.client.mgcp.parser.params.RestartMethodHandler;
import org.restcomm.media.client.mgcp.parser.params.ReturnCodeHandler;
import org.restcomm.media.client.mgcp.stack.JainMgcpStackImpl;

public class AuditEndpointHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{65, 85, 69, 80};
    private static final Logger logger = Logger.getLogger(AuditEndpointHandler.class);
    private AuditEndpoint command;
    private AuditEndpointResponse response;

    public AuditEndpointHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public AuditEndpointHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    @Override
    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new AuditEndpoint(this.source != null ? this.source : this.stack, this.endpoint);
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    @Override
    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new AuditEndpointResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            logger.error((Object)"Decoding of AUEP Response failed", (Throwable)e);
        }
        return this.response;
    }

    @Override
    public int encode(JainMgcpCommandEvent event, byte[] array) {
        AuditEndpoint evt = (AuditEndpoint)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        InfoCode[] requestedInfos = evt.getRequestedInfo();
        if (requestedInfos != null) {
            array[totalLength++] = 70;
            array[totalLength++] = 58;
            array[totalLength++] = 32;
            totalLength += InfoCodeHandler.encodeList(array, totalLength, requestedInfos);
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public int encode(JainMgcpResponseEvent event, byte[] array) {
        EndpointIdentifier[] z;
        EventName[] es;
        EventName[] t;
        EventName[] o;
        EventName[] sEvet;
        RequestedEvent[] r;
        ConnectionIdentifier[] connectionIdentifiers;
        AuditEndpointResponse response = (AuditEndpointResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        if (response.getCapabilities() != null) {
            array[totalLength++] = 65;
            array[totalLength++] = 58;
            totalLength += CapabilityHandler.encodeList(array, totalLength, response.getCapabilities());
            array[totalLength++] = 10;
        }
        if (response.getBearerInformation() != null) {
            array[totalLength++] = 66;
            array[totalLength++] = 58;
            totalLength += BearerInformationHandler.encode(array, totalLength, response.getBearerInformation());
            array[totalLength++] = 10;
        }
        if ((connectionIdentifiers = response.getConnectionIdentifiers()) != null) {
            array[totalLength++] = 73;
            array[totalLength++] = 58;
            if (connectionIdentifiers.length > 0) {
                byte[] connectionBytes;
                int i;
                for (i = 0; i < connectionIdentifiers.length - 1; ++i) {
                    connectionBytes = connectionIdentifiers[i].toString().getBytes();
                    System.arraycopy(connectionBytes, 0, array, totalLength, connectionBytes.length);
                    totalLength += connectionBytes.length;
                    array[totalLength++] = 44;
                }
                connectionBytes = connectionIdentifiers[i].toString().getBytes();
                System.arraycopy(connectionBytes, 0, array, totalLength, connectionBytes.length);
                totalLength += connectionBytes.length;
            }
            array[totalLength++] = 10;
        }
        if (response.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, response.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        if (response.getRequestIdentifier() != null) {
            array[totalLength++] = 88;
            array[totalLength++] = 58;
            byte[] requestBytes = response.getRequestIdentifier().toString().getBytes();
            System.arraycopy(requestBytes, 0, array, totalLength, requestBytes.length);
            totalLength += requestBytes.length;
            array[totalLength++] = 10;
        }
        if ((r = response.getRequestedEvents()) != null) {
            array[totalLength++] = 83;
            array[totalLength++] = 58;
            totalLength += RequestedEventHandler.encodeList(array, totalLength, r);
            array[totalLength++] = 10;
        }
        if ((sEvet = response.getSignalRequests()) != null) {
            array[totalLength++] = 83;
            array[totalLength++] = 58;
            totalLength += EventNameHandler.encodeList(array, totalLength, sEvet);
            array[totalLength++] = 10;
        }
        if (response.getDigitMap() != null) {
            array[totalLength++] = 68;
            array[totalLength++] = 58;
            totalLength += DigitMapHandler.encode(array, totalLength, response.getDigitMap());
            array[totalLength++] = 10;
        }
        if ((o = response.getObservedEvents()) != null) {
            array[totalLength++] = 79;
            array[totalLength++] = 58;
            totalLength += EventNameHandler.encodeList(array, totalLength, o);
            array[totalLength++] = 10;
        }
        if (response.getReasonCode() != null) {
            array[totalLength++] = 69;
            array[totalLength++] = 58;
            totalLength += ReasonCodeHandler.encode(array, totalLength, response.getReasonCode());
            array[totalLength++] = 10;
        }
        if ((t = response.getDetectEvents()) != null) {
            array[totalLength++] = 84;
            array[totalLength++] = 58;
            totalLength += EventNameHandler.encodeList(array, totalLength, t);
            array[totalLength++] = 10;
        }
        if ((es = response.getEventStates()) != null) {
            array[totalLength++] = 69;
            array[totalLength++] = 83;
            array[totalLength++] = 58;
            totalLength += EventNameHandler.encodeList(array, totalLength, es);
            array[totalLength++] = 10;
        }
        if (response.getRestartMethod() != null) {
            array[totalLength++] = 82;
            array[totalLength++] = 77;
            array[totalLength++] = 58;
            totalLength += RestartMethodHandler.encode(array, totalLength, response.getRestartMethod());
            array[totalLength++] = 10;
        }
        if (response.getRestartDelay() > 0) {
            array[totalLength++] = 82;
            array[totalLength++] = 68;
            array[totalLength++] = 58;
            totalLength += StringFunctions.encodeInt(array, totalLength, response.getRestartDelay());
            array[totalLength++] = 10;
        }
        if ((z = response.getEndpointIdentifierList()) != null) {
            array[totalLength++] = 90;
            array[totalLength++] = 58;
            totalLength += EndpointIdentifierHandler.encodeList(array, totalLength, z);
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public JainMgcpResponseEvent getProvisionalResponse() {
        AuditEndpointResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new AuditEndpointResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() != 1) {
                switch (data[name.getOffset()]) {
                    case 90: 
                    case 122: {
                        EndpointIdentifier[] endpointIdentifierList = EndpointIdentifierHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setEndpointIdentifierList(endpointIdentifierList);
                        break;
                    }
                    case 66: 
                    case 98: {
                        BearerInformation b = BearerInformationHandler.decode(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setBearerInformation(b);
                        break;
                    }
                    case 73: 
                    case 105: {
                        ConnectionIdentifier[] is = AuditEndpointHandler.this.response.getConnectionIdentifiers();
                        if (is == null) {
                            ConnectionIdentifier i = new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength()));
                            AuditEndpointHandler.this.response.setConnectionIdentifiers(new ConnectionIdentifier[]{i});
                            break;
                        }
                        ArrayList<ConnectionIdentifier> arrayList = new ArrayList<ConnectionIdentifier>();
                        Collections.addAll(arrayList, is);
                        arrayList.add(new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength())));
                        ConnectionIdentifier[] temp = new ConnectionIdentifier[arrayList.size()];
                        AuditEndpointHandler.this.response.setConnectionIdentifiers(arrayList.toArray(temp));
                        break;
                    }
                    case 78: 
                    case 110: {
                        NotifiedEntity n = NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), true);
                        AuditEndpointHandler.this.response.setNotifiedEntity(n);
                        break;
                    }
                    case 88: 
                    case 120: {
                        RequestIdentifier ri = new RequestIdentifier(new String(data, value.getOffset(), value.getLength()));
                        AuditEndpointHandler.this.response.setRequestIdentifier(ri);
                        break;
                    }
                    case 82: 
                    case 114: {
                        RequestedEvent[] r = RequestedEventHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setRequestedEvents(r);
                        break;
                    }
                    case 83: 
                    case 115: {
                        EventName[] s = EventNameHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setSignalRequests(s);
                        break;
                    }
                    case 68: 
                    case 100: {
                        DigitMap d = DigitMapHandler.decode(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setDigitMap(d);
                        break;
                    }
                    case 79: 
                    case 111: {
                        EventName[] o = EventNameHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setObservedEvents(o);
                        break;
                    }
                    case 69: 
                    case 101: {
                        ReasonCode e = ReasonCodeHandler.decode(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setReasonCode(e);
                        break;
                    }
                    case 84: 
                    case 116: {
                        EventName[] t = EventNameHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditEndpointHandler.this.response.setDetectEvents(t);
                        break;
                    }
                    case 65: 
                    case 97: {
                        CapabilityValue[] capabilities = AuditEndpointHandler.this.response.getCapabilities();
                        if (capabilities == null) {
                            AuditEndpointHandler.this.response.setCapabilities(CapabilityHandler.decodeList(data, value.getOffset(), value.getLength()));
                            break;
                        }
                        CapabilityValue[] newCapability = CapabilityHandler.decodeList(data, value.getOffset(), value.getLength());
                        CapabilityValue[] temp = new CapabilityValue[capabilities.length + newCapability.length];
                        System.arraycopy(capabilities, 0, temp, 0, capabilities.length);
                        System.arraycopy(newCapability, 0, temp, capabilities.length, newCapability.length);
                        AuditEndpointHandler.this.response.setCapabilities(temp);
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified AUEP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else if (name.getLength() == 2) {
                switch (data[name.getOffset() + 1]) {
                    case 83: 
                    case 115: {
                        if (data[name.getOffset()] == 101 || data[name.getOffset()] == 69) {
                            EventName[] es = EventNameHandler.decodeList(data, value.getOffset(), value.getLength());
                            AuditEndpointHandler.this.response.setEventStates(es);
                            break;
                        }
                        logger.warn((Object)("Unidentified AUEP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 68: 
                    case 100: {
                        if (data[name.getOffset()] == 114 || data[name.getOffset()] == 82) {
                            Integer restartDelay = new Integer(0);
                            int currIndex = value.getOffset();
                            int j = 0;
                            while (j < value.getLength()) {
                                if (data[currIndex] < 48 || data[currIndex] > 57) {
                                    throw new ParseException("Invalid restart delay:" + new String(data, value.getOffset(), value.getLength()), 0);
                                }
                                restartDelay = restartDelay * 10 + (data[currIndex] - 48);
                                ++j;
                                ++currIndex;
                            }
                            AuditEndpointHandler.this.response.setRestartDelay(restartDelay.intValue());
                            break;
                        }
                        logger.warn((Object)("Unidentified AUEP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 77: 
                    case 109: {
                        if (data[name.getOffset()] == 114 || data[name.getOffset()] == 82) {
                            RestartMethod rm = RestartMethodHandler.decode(data, value.getOffset(), value.getLength());
                            AuditEndpointHandler.this.response.setRestartMethod(rm);
                            break;
                        }
                        logger.warn((Object)("Unidentified AUEP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified AUEP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified AUEP Response parameter " + name + " with value = " + value));
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() != 1) {
                logger.warn((Object)("Unidentified AUEP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            } else {
                switch (data[name.getOffset()]) {
                    case 70: 
                    case 102: {
                        AuditEndpointHandler.this.command.setRequestedInfo(InfoCodeHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified AUEP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                    }
                }
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            throw new ParseException("SessionDescription shouldn't have been included in AUEP command", 0);
        }
    }
}

