/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.jain.pkg.AUMgcpEvent;
import org.restcomm.media.client.mgcp.jain.pkg.AUPackage;
import org.restcomm.media.client.mgcp.jain.pkg.SLPackage;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;
import org.restcomm.media.client.mgcp.parser.pkg.PackageNameHandler;

public class EventNameHandler {
    static PackageName auPackage = AUPackage.AU;
    static PackageName slPackage = SLPackage.SL;
    static MgcpEvent rfc2897pa = AUMgcpEvent.aupa;

    private static MgcpEvent generateEvent(byte[] value, int offset, int length) throws ParseException {
        if (length == 2) {
            switch (value[offset + 1]) {
                case 83: 
                case 115: {
                    if (value[offset] == 101 || value[offset] == 69) {
                        return AUMgcpEvent.aues;
                    }
                }
                case 82: 
                case 114: {
                    if (value[offset] == 112 || value[offset] == 80) {
                        return AUMgcpEvent.aupr;
                    }
                }
                case 67: 
                case 99: {
                    if (value[offset] != 112 && value[offset] != 80) break;
                    return AUMgcpEvent.aupc;
                }
            }
        }
        return MgcpEvent.factory((String)new String(value, offset, length));
    }

    private static EventName decode(byte[] value, int offset, int length, String params) throws ParseException {
        MgcpEvent mgcpEvent;
        PackageName packageName;
        int currIndex = offset;
        int slashIndex = -1;
        int atIndex = -1;
        int i = 0;
        while (i < length) {
            if (value[currIndex] == 47) {
                if (slashIndex >= 0) {
                    throw new ParseException("Unknown value for Event Name: " + new String(value, offset, length), 0);
                }
                slashIndex = currIndex;
            } else if (value[currIndex] == 64) {
                if (slashIndex < 0) {
                    throw new ParseException("Unknown value for Event Name: " + new String(value, offset, length), 0);
                }
                atIndex = currIndex;
                break;
            }
            ++i;
            ++currIndex;
        }
        if (slashIndex >= 0) {
            packageName = PackageNameHandler.decode(value, offset, slashIndex - offset);
            mgcpEvent = atIndex >= 0 ? EventNameHandler.generateEvent(value, slashIndex + 1, atIndex - slashIndex - 1) : EventNameHandler.generateEvent(value, slashIndex + 1, length + offset - slashIndex - 1);
        } else {
            packageName = PackageName.AllPackages;
            mgcpEvent = atIndex >= 0 ? EventNameHandler.generateEvent(value, offset, atIndex - offset) : EventNameHandler.generateEvent(value, offset, length);
        }
        ConnectionIdentifier connectionIdentifier = null;
        if (atIndex >= 0) {
            if (length + offset - atIndex - 1 == 1) {
                switch (value[atIndex + 1]) {
                    case 36: {
                        connectionIdentifier = ConnectionIdentifier.AnyConnection;
                        break;
                    }
                    case 42: {
                        connectionIdentifier = ConnectionIdentifier.AllConnections;
                        break;
                    }
                    default: {
                        connectionIdentifier = new ConnectionIdentifier(new String(value, atIndex + 1, 1));
                        break;
                    }
                }
            } else {
                connectionIdentifier = new ConnectionIdentifier(new String(value, atIndex + 1, length + offset - atIndex - 1));
            }
        }
        if (params == null) {
            return new EventName(packageName, mgcpEvent, connectionIdentifier);
        }
        return new EventName(packageName, mgcpEvent.withParm(params), connectionIdentifier);
    }

    public static EventName decode(byte[] value, int offset, int length) throws ParseException {
        return EventNameHandler.decode(value, offset, length, null);
    }

    public static EventName decodeWithParams(byte[] value, int offset, int length, int paramsOffset, int paramsLength) throws ParseException {
        return EventNameHandler.decode(value, offset, length, new String(value, paramsOffset, paramsLength));
    }

    public static int encode(byte[] destination, int offset, EventName eventName) {
        int totalLength = PackageNameHandler.encode(destination, offset, eventName.getPackageName());
        destination[offset + totalLength] = 47;
        byte[] nameBytes = eventName.getEventIdentifier().getName().getBytes();
        System.arraycopy(nameBytes, 0, destination, offset + ++totalLength, nameBytes.length);
        totalLength += nameBytes.length;
        if (eventName.getConnectionIdentifier() != null) {
            destination[offset + totalLength] = 64;
            byte[] connectionBytes = eventName.getConnectionIdentifier().toString().getBytes();
            System.arraycopy(connectionBytes, 0, destination, offset + ++totalLength, connectionBytes.length);
            totalLength += connectionBytes.length;
        }
        return totalLength;
    }

    public static int encodeParams(byte[] destination, int offset, EventName eventName) {
        if (eventName.getEventIdentifier().getParms() == null) {
            return 0;
        }
        destination[offset] = 40;
        byte[] paramsBytes = eventName.getEventIdentifier().getParms().getBytes();
        System.arraycopy(paramsBytes, 0, destination, offset + 1, paramsBytes.length);
        destination[offset + paramsBytes.length + 1] = 41;
        return paramsBytes.length + 2;
    }

    public static int encodeList(byte[] destination, int offset, EventName[] eventNames) {
        int i;
        if (eventNames.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < eventNames.length - 1; ++i) {
            totalLength += EventNameHandler.encode(destination, offset + totalLength, eventNames[i]);
            totalLength += EventNameHandler.encodeParams(destination, offset + totalLength, eventNames[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += EventNameHandler.encode(destination, offset + totalLength, eventNames[i]);
        totalLength += EventNameHandler.encodeParams(destination, offset + totalLength, eventNames[i]);
        return totalLength;
    }

    public static EventName[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)44);
        EventName[] events = new EventName[splitDetails.length];
        Boolean found = false;
        for (int i = 0; i < splitDetails.length; ++i) {
            if (value[splitDetails[i].getOffset() + splitDetails[i].getLength() - 1] == 41) {
                found = false;
                for (int j = 0; j < splitDetails[i].getLength(); ++j) {
                    if (value[splitDetails[i].getOffset() + j] != 40) continue;
                    events[i] = EventNameHandler.decodeWithParams(value, splitDetails[i].getOffset(), j, splitDetails[i].getOffset() + j + 1, splitDetails[i].getLength() - j - 2);
                    found = true;
                    break;
                }
                if (found.booleanValue()) continue;
                events[i] = EventNameHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
                continue;
            }
            events[i] = EventNameHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return events;
    }
}

