/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.restcomm.media.client.mgcp.handlers.MgcpContentHandler;
import org.restcomm.media.client.mgcp.handlers.TransactionHandler;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;
import org.restcomm.media.client.mgcp.parser.params.DigitMapHandler;
import org.restcomm.media.client.mgcp.parser.params.EndpointIdentifierHandler;
import org.restcomm.media.client.mgcp.parser.params.EventNameHandler;
import org.restcomm.media.client.mgcp.parser.params.NotifiedEntityHandler;
import org.restcomm.media.client.mgcp.parser.params.RequestedEventHandler;
import org.restcomm.media.client.mgcp.parser.params.ReturnCodeHandler;
import org.restcomm.media.client.mgcp.stack.JainMgcpStackImpl;

public class NotificationRequestHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{82, 81, 78, 84};
    private static final Logger logger = Logger.getLogger(NotificationRequestHandler.class);
    private NotificationRequest command;
    private NotificationRequestResponse response;

    public NotificationRequestHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public NotificationRequestHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    @Override
    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new NotificationRequest(this.source != null ? this.source : this.stack, this.endpoint, new RequestIdentifier("0"));
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), -1);
        }
        NotifiedEntity notifiedEntity = this.command.getNotifiedEntity();
        if (this.command.getNotifiedEntity() != null) {
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
        return this.command;
    }

    @Override
    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new NotificationRequestResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            logger.error((Object)"Decode RQNT Response failed", (Throwable)e);
        }
        return this.response;
    }

    @Override
    public int encode(JainMgcpCommandEvent event, byte[] array) {
        NotificationRequest evt = (NotificationRequest)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        if (evt.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, evt.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        array[totalLength++] = 88;
        array[totalLength++] = 58;
        byte[] requestBytes = evt.getRequestIdentifier().toString().getBytes();
        System.arraycopy(requestBytes, 0, array, totalLength, requestBytes.length);
        totalLength += requestBytes.length;
        array[totalLength++] = 10;
        if (evt.getDigitMap() != null) {
            array[totalLength++] = 68;
            array[totalLength++] = 58;
            totalLength += DigitMapHandler.encode(array, totalLength, evt.getDigitMap());
            array[totalLength++] = 10;
        }
        if (evt.getSignalRequests() != null) {
            array[totalLength++] = 83;
            array[totalLength++] = 58;
            totalLength += EventNameHandler.encodeList(array, totalLength, evt.getSignalRequests());
            array[totalLength++] = 10;
        }
        if (evt.getRequestedEvents() != null) {
            array[totalLength++] = 82;
            array[totalLength++] = 58;
            totalLength += RequestedEventHandler.encodeList(array, totalLength, evt.getRequestedEvents());
            array[totalLength++] = 10;
        }
        if (evt.getDetectEvents() != null) {
            array[totalLength++] = 84;
            array[totalLength++] = 58;
            totalLength += EventNameHandler.encodeList(array, totalLength, evt.getDetectEvents());
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public int encode(JainMgcpResponseEvent event, byte[] array) {
        NotificationRequestResponse response = (NotificationRequestResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        return totalLength;
    }

    @Override
    public JainMgcpResponseEvent getProvisionalResponse() {
        NotificationRequestResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new NotificationRequestResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 78: 
                    case 110: {
                        NotifiedEntity n = NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), true);
                        NotificationRequestHandler.this.command.setNotifiedEntity(n);
                        break;
                    }
                    case 88: 
                    case 120: {
                        NotificationRequestHandler.this.command.setRequestIdentifier(new RequestIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 82: 
                    case 114: {
                        NotificationRequestHandler.this.command.setRequestedEvents(RequestedEventHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 83: 
                    case 115: {
                        NotificationRequestHandler.this.command.setSignalRequests(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 84: 
                    case 116: {
                        NotificationRequestHandler.this.command.setDetectEvents(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 68: 
                    case 100: {
                        NotificationRequestHandler.this.command.setDigitMap(DigitMapHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified RQNT Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified RQNT Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

