/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import java.text.ParseException;

public class RestartMethodHandler {
    private static final byte[] GRACEFUL_VALUE = new byte[]{103, 114, 97, 99, 101, 102, 117, 108};
    private static final byte[] FORCED_VALUE = new byte[]{102, 111, 114, 99, 101, 100};
    private static final byte[] RESTART_VALUE = new byte[]{114, 101, 115, 116, 97, 114, 116};
    private static final byte[] DISCONNECTED_VALUE = new byte[]{100, 105, 115, 99, 111, 110, 110, 101, 99, 116, 101, 100};
    private static final byte[] CANCEL_GRACEFUL_VALUE = new byte[]{99, 97, 110, 99, 101, 108, 45, 103, 114, 97, 116, 101, 102, 117, 108};

    public static RestartMethod decode(byte[] value, int offset, int length) throws ParseException {
        switch (length) {
            case 6: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == FORCED_VALUE[i] || value[offset + i] == (byte)(FORCED_VALUE[i] + -32)) continue;
                    throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
                }
                return RestartMethod.Forced;
            }
            case 7: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == RESTART_VALUE[i] || value[offset + i] == (byte)(RESTART_VALUE[i] + -32)) continue;
                    throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
                }
                return RestartMethod.Restart;
            }
            case 8: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == GRACEFUL_VALUE[i] || value[offset + i] == (byte)(GRACEFUL_VALUE[i] + -32)) continue;
                    throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
                }
                return RestartMethod.Graceful;
            }
            case 12: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == DISCONNECTED_VALUE[i] || value[offset + i] == (byte)(DISCONNECTED_VALUE[i] + -32)) continue;
                    throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
                }
                return RestartMethod.Disconnected;
            }
            case 15: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == CANCEL_GRACEFUL_VALUE[i] || value[offset + i] == (byte)(CANCEL_GRACEFUL_VALUE[i] + -32)) continue;
                    throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
                }
                return RestartMethod.CancelGraceful;
            }
        }
        throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, RestartMethod restartMethod) {
        switch (restartMethod.getRestartMethod()) {
            case 2: {
                System.arraycopy(FORCED_VALUE, 0, destination, offset, FORCED_VALUE.length);
                return FORCED_VALUE.length;
            }
            case 3: {
                System.arraycopy(RESTART_VALUE, 0, destination, offset, RESTART_VALUE.length);
                return RESTART_VALUE.length;
            }
            case 1: {
                System.arraycopy(GRACEFUL_VALUE, 0, destination, offset, GRACEFUL_VALUE.length);
                return GRACEFUL_VALUE.length;
            }
            case 4: {
                System.arraycopy(DISCONNECTED_VALUE, 0, destination, offset, DISCONNECTED_VALUE.length);
                return DISCONNECTED_VALUE.length;
            }
            case 5: {
                System.arraycopy(CANCEL_GRACEFUL_VALUE, 0, destination, offset, CANCEL_GRACEFUL_VALUE.length);
                return CANCEL_GRACEFUL_VALUE.length;
            }
        }
        return 0;
    }
}

