/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.TypeOfNetwork;
import java.text.ParseException;

public class TypeOfNetworkHandler {
    private static final byte[] IN_VALUE = new byte[]{105, 110};
    private static final byte[] ATM_VALUE = new byte[]{97, 116, 109};
    private static final byte[] LOCAL_VALUE = new byte[]{108, 111, 99, 97, 108};

    public static TypeOfNetwork decode(byte[] value, int offset, int length) throws ParseException {
        switch (length) {
            case 2: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == IN_VALUE[i] || value[offset + i] == (byte)(IN_VALUE[i] + -32)) continue;
                    throw new ParseException("Invalid type of network:" + new String(value, offset, length), 0);
                }
                return TypeOfNetwork.In;
            }
            case 3: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == ATM_VALUE[i] || value[offset + i] == (byte)(ATM_VALUE[i] + -32)) continue;
                    throw new ParseException("Invalid type of network:" + new String(value, offset, length), 0);
                }
                return TypeOfNetwork.Atm;
            }
            case 5: {
                for (int i = 0; i < length; ++i) {
                    if (value[offset + i] == LOCAL_VALUE[i] || value[offset + i] == (byte)(LOCAL_VALUE[i] + -32)) continue;
                    throw new ParseException("Invalid type of network:" + new String(value, offset, length), 0);
                }
                return TypeOfNetwork.Local;
            }
        }
        throw new ParseException("Extension restarts not (yet) supported:" + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, TypeOfNetwork typeOfNetwork) {
        switch (typeOfNetwork.getTypeOfNetwork()) {
            case 1: {
                System.arraycopy(IN_VALUE, 0, destination, offset, IN_VALUE.length);
                return IN_VALUE.length;
            }
            case 2: {
                System.arraycopy(ATM_VALUE, 0, destination, offset, ATM_VALUE.length);
                return ATM_VALUE.length;
            }
            case 3: {
                System.arraycopy(LOCAL_VALUE, 0, destination, offset, LOCAL_VALUE.length);
                return LOCAL_VALUE.length;
            }
        }
        return 0;
    }
}

