/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class ConnectionModeHandler {
    private static final byte[] SENDRECV_VALUE = new byte[]{115, 101, 110, 100, 114, 101, 99, 118};
    private static final byte[] SENDONLY_VALUE = new byte[]{115, 101, 110, 100, 111, 110, 108, 121};
    private static final byte[] RECVONLY_VALUE = new byte[]{114, 101, 99, 118, 111, 110, 108, 121};
    private static final byte[] CONFRNCE_VALUE = new byte[]{99, 111, 110, 102, 114, 110, 99, 101};
    private static final byte[] CONTTEST_VALUE = new byte[]{99, 111, 110, 116, 116, 101, 115, 116};
    private static final byte[] LOOPBACK_VALUE = new byte[]{108, 111, 111, 112, 98, 97, 99, 107};
    private static final byte[] NETWLOOP_VALUE = new byte[]{110, 101, 116, 119, 108, 111, 111, 112};
    private static final byte[] NETWTEST_VALUE = new byte[]{110, 101, 116, 119, 116, 101, 115, 116};
    private static final byte[] INACTIVE_VALUE = new byte[]{105, 110, 97, 99, 116, 105, 118, 101};
    private static final byte[] DATA_VALUE = new byte[]{100, 97, 116, 97};

    public static ConnectionMode decode(byte[] value, int offset, int length) throws ParseException {
        if (length == 8) {
            byte startByte = value[offset];
            byte middleByte = value[offset + 4];
            byte char1 = value[offset + 1];
            byte char2 = value[offset + 2];
            byte char3 = value[offset + 3];
            byte char5 = value[offset + 5];
            byte char6 = value[offset + 6];
            byte char7 = value[offset + 7];
            switch (startByte) {
                case 83: 
                case 115: {
                    switch (middleByte) {
                        case 82: 
                        case 114: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == SENDRECV_VALUE[i] || value[offset + i] == (byte)(SENDRECV_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == SENDRECV_VALUE[i] || value[offset + i] == (byte)(SENDRECV_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.SendRecv;
                        }
                        case 79: 
                        case 111: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == SENDONLY_VALUE[i] || value[offset + i] == (byte)(SENDONLY_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == SENDONLY_VALUE[i] || value[offset + i] == (byte)(SENDONLY_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.SendOnly;
                        }
                    }
                    break;
                }
                case 82: 
                case 114: {
                    switch (middleByte) {
                        case 79: 
                        case 111: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == RECVONLY_VALUE[i] || value[offset + i] == (byte)(RECVONLY_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == RECVONLY_VALUE[i] || value[offset + i] == (byte)(RECVONLY_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.RecvOnly;
                        }
                    }
                    break;
                }
                case 67: 
                case 99: {
                    switch (middleByte) {
                        case 82: 
                        case 114: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == CONFRNCE_VALUE[i] || value[offset + i] == (byte)(CONFRNCE_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == CONFRNCE_VALUE[i] || value[offset + i] == (byte)(CONFRNCE_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.Confrnce;
                        }
                        case 84: 
                        case 116: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == CONTTEST_VALUE[i] || value[offset + i] == (byte)(CONTTEST_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == CONTTEST_VALUE[i] || value[offset + i] == (byte)(CONTTEST_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.Conttest;
                        }
                    }
                    break;
                }
                case 76: 
                case 108: {
                    switch (middleByte) {
                        case 66: 
                        case 98: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == LOOPBACK_VALUE[i] || value[offset + i] == (byte)(LOOPBACK_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == LOOPBACK_VALUE[i] || value[offset + i] == (byte)(LOOPBACK_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.Loopback;
                        }
                    }
                    break;
                }
                case 78: 
                case 110: {
                    switch (middleByte) {
                        case 76: 
                        case 108: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == NETWLOOP_VALUE[i] || value[offset + i] == (byte)(NETWLOOP_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == NETWLOOP_VALUE[i] || value[offset + i] == (byte)(NETWLOOP_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.Netwloop;
                        }
                        case 84: 
                        case 116: {
                            int i;
                            for (i = 1; i < 4; ++i) {
                                if (value[offset + i] == NETWTEST_VALUE[i] || value[offset + i] == (byte)(NETWTEST_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            for (i = 5; i < 8; ++i) {
                                if (value[offset + i] == NETWTEST_VALUE[i] || value[offset + i] == (byte)(NETWTEST_VALUE[i] + -32)) continue;
                                return ConnectionMode.Inactive;
                            }
                            return ConnectionMode.Netwtest;
                        }
                    }
                }
            }
        } else if (length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (value[offset + i] == DATA_VALUE[i] || value[offset + i] == (byte)(DATA_VALUE[i] + -32)) continue;
                return ConnectionMode.Inactive;
            }
            return ConnectionMode.Data;
        }
        return ConnectionMode.Inactive;
    }

    public static int encode(byte[] destination, int offset, ConnectionMode connectionMode) {
        switch (connectionMode.getConnectionModeValue()) {
            case 3: {
                System.arraycopy(SENDRECV_VALUE, 0, destination, offset, SENDRECV_VALUE.length);
                return SENDRECV_VALUE.length;
            }
            case 1: {
                System.arraycopy(SENDONLY_VALUE, 0, destination, offset, SENDONLY_VALUE.length);
                return SENDONLY_VALUE.length;
            }
            case 2: {
                System.arraycopy(RECVONLY_VALUE, 0, destination, offset, RECVONLY_VALUE.length);
                return RECVONLY_VALUE.length;
            }
            case 4: {
                System.arraycopy(CONFRNCE_VALUE, 0, destination, offset, CONFRNCE_VALUE.length);
                return CONFRNCE_VALUE.length;
            }
            case 5: {
                System.arraycopy(INACTIVE_VALUE, 0, destination, offset, INACTIVE_VALUE.length);
                return INACTIVE_VALUE.length;
            }
            case 6: {
                System.arraycopy(LOOPBACK_VALUE, 0, destination, offset, LOOPBACK_VALUE.length);
                return LOOPBACK_VALUE.length;
            }
            case 7: {
                System.arraycopy(CONTTEST_VALUE, 0, destination, offset, CONTTEST_VALUE.length);
                return CONTTEST_VALUE.length;
            }
            case 8: {
                System.arraycopy(NETWLOOP_VALUE, 0, destination, offset, NETWLOOP_VALUE.length);
                return NETWLOOP_VALUE.length;
            }
            case 9: {
                System.arraycopy(NETWTEST_VALUE, 0, destination, offset, NETWTEST_VALUE.length);
                return NETWTEST_VALUE.length;
            }
            case 10: {
                System.arraycopy(DATA_VALUE, 0, destination, offset, DATA_VALUE.length);
                return DATA_VALUE.length;
            }
        }
        return 0;
    }

    public static int encodeList(byte[] destination, int offset, ConnectionMode[] connectionModes) {
        int i;
        if (connectionModes.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < connectionModes.length - 1; ++i) {
            totalLength += ConnectionModeHandler.encode(destination, offset + totalLength, connectionModes[i]);
            destination[offset + totalLength] = 59;
            ++totalLength;
        }
        totalLength += ConnectionModeHandler.encode(destination, offset + totalLength, connectionModes[i]);
        return totalLength;
    }

    public static ConnectionMode[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)59);
        ConnectionMode[] connectionModes = new ConnectionMode[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            connectionModes[i] = ConnectionModeHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return connectionModes;
    }
}

